# LMSAPI/API/Term.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle


class Course:
    def __init__(self):
        self.cid = 0
        self.course = ""

    def serialize(self):
        return {
            "cid": self.cid,
            "course": self.course,
        }

    def get_course_list_from_redis(self, lname, groupid, termid):
        cachedClist = current_app.ms.redis(lname).get(
            "SYSCOLIST" + str(groupid) + str(termid)
        )
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def set_group_list_to_redis(self, lname, clist, groupid, termid):
        current_app.ms.redis(lname).setex(
            "SYSCOLIST" + str(groupid) + str(termid), 5, pickle.dumps(clist)
        )
        return

    def searchCourse(self, lname, searchparameter):
        conn = current_app.ms.db(lname).connect()

        sql = """select cid,title,alias from courses where (title like :u or alias like :u) order by title"""
        stmt = text(sql)
        searchparameter = "%" + searchparameter + "%"
        stmt = stmt.bindparams(u=searchparameter)

        query = conn.execute(stmt)
        searchDetails = {
            "courseSearchResult": [
                dict(zip(tuple(query.keys()), i)) for i in query.cursor
            ]
        }
        return searchDetails

    def getCourse(self, lname, id):
        # cc = Cathedra()

        # result = cc.get_cathedra_from_redis(id)

        # if result is not None:
        #   return result
        conn = current_app.ms.db(lname).connect()
        stmt = text(
            """
            SELECT xp_fill_curriculum(:id); 
            SELECT 
                    fin_exam, 
                    fin_test, 
                    fin_test_with_grade, 
                    fin_test_work, 
                    courses.*, 
                    meta_course.name as meta_course_name

            FROM tmp_plan 
            LEFT JOIN courses ON tmp_plan.cid=courses.cid 
            LEFT JOIN meta_course ON courses.meta_course = meta_course.id
            WHERE tmp_plan.cid=:id
            """
        )
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["course"]) == 0:
            conn = current_app.ms.db(lname).connect()
            stmt = text(
                """
            select 
                    courses.*,
                    meta_course.name as meta_course_name
            from courses 
            left join meta_course on courses.meta_course = meta_course.id
            where cid=:id
            """
            )
            stmt = stmt.bindparams(id=id)
            query = conn.execute(stmt)
            result = {
                "course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
            }
            if len(result["course"]) == 0:
                return None
            return result

        return result

    def getCourseListGT(self, lname, groupid, termid):
        c = Course()

        # cathedraList = c.get_cathedra_list_from_redis(faculty)

        # if cathedraList is not None:
        #    return cathedraList

        conn = current_app.ms.db(lname).connect()

        sql = """  select 
                   c.cid, 
                   concat_ws(' ', c.course_index, c.title) as course
         from 
                   nnz_weeks       w 
         join      term_weeks      tw on w.week_id = tw.week_id 
         join      nnz_schedule    sh on sh.sh_var_id = w.sh_var_id 
         join      courses         c  on sh.cid = c.cid 
         join      groupname       g1 on sh.gid = g1.gid 
         where 
                   ( 
                       g1.gid = :groupid or g1.owner_gid = :groupid
                   ) 
                   and  
                       sh.day_of_week - 1 between weekday(w.wstart_date) and weekday(w.wend_date)  
                   and
                   tw.trmid = :termid
         group by 
                   c.cid, 
                   c.title, 
                   c.course_index 
         order by 
                   c.title"""

        stmt = text(sql)
        stmt = stmt.bindparams(groupid=groupid)
        stmt = stmt.bindparams(termid=termid)
        query = conn.execute(stmt)

        courseList = []

        for row in query:
            rcourse = Course()
            rcourse.cid = row.cid
            rcourse.course = row.course
            courseList.append(rcourse)

        # c.set_cathedra_list_to_redis(cathedraList,faculty)

        return courseList

    def get_lesson_plans_сourse_list(self, lname, idcurriculum, idmetacourse):
        conn = current_app.ms.db(lname).connect()

        base_sql = """
        select distinct c.cid, concat_ws(' ', c.title, concat('(', c.course_index, ')')) as course
        from courses c
        inner join curriculum_detail cd on cd.cid = c.cid
        join curriculum clm on clm.idcurriculum = cd.idcurriculum
        join qualif_demands q on q.q_demand_id = clm.q_demand_id
        where (%(curriculum_filter)s)
        %(meta_course_filter)s
        and c.cid in (
            select cid from q_demand_disciplines where q_demand_id = q.q_demand_id
            union select cid from q_demand_ovp where q_demand_id = q.q_demand_id
            union select cid from q_demand_practice where q_demand_id = q.q_demand_id
            union select cid from q_demand_req where q_demand_id = q.q_demand_id
            union select cid from q_demand_tsu where q_demand_id = q.q_demand_id
        )
        order by 2
        """

        curriculum_filter = (
            "1=1" if idcurriculum == 0 else "cd.idcurriculum = :idcurriculum"
        )
        meta_course_filter = (
            "" if idmetacourse == 0 else "and c.meta_course = :idmetacourse"
        )

        sql = base_sql % {
            "curriculum_filter": curriculum_filter,
            "meta_course_filter": meta_course_filter,
        }

        params = {}

        if idcurriculum != 0:
            params["idcurriculum"] = idcurriculum

        if idmetacourse != 0:
            params["idmetacourse"] = idmetacourse

        stmt = text(sql).bindparams(**params)
        query = conn.execute(stmt)

        courseList = []

        for row in query:
            rcourse = Course()
            rcourse.cid = row.cid
            rcourse.course = row.course
            courseList.append(rcourse)

        return courseList

    @staticmethod
    def get_course_list_gt_for_teacher(lname, group_id, termid, mid):
        conn = current_app.ms.db(lname).connect()

        if not g.user.user_is_rasdel_admin(g.user.mid, "Журнал учета учебных занятий. Администратор"):
            predmet_filter = """ 
            AND (({mid} = ANY(s.teacher_mid)) OR (s.cid IN (SELECT cid FROM teachers WHERE mid = {mid} AND cid > 0)))
            """.format(mid=mid)
        else:
            predmet_filter = ""

        sql = """
        SELECT c.cid, concat_ws(' ', c.title,c.course_index) AS title
        FROM vw_schedule v
        JOIN nnz_schedule s on s.sheid=v.sheid
        JOIN groupname gm on gm.gid=v.main_gid
        JOIN courses c on c.cid=s.cid
        LEFT JOIN eventtools et ON et.typeid = s.pair_type_id
        LEFT JOIN processes pr ON pr.pid = et.processtypeid
        WHERE v.trmid=:termid
            AND COALESCE(pr.summary_group, 0) NOT IN (2, 3)
            and gm.gid=:group_id {predmet_filter}
        GROUP BY c.cid, c.course_index,c.title
        ORDER BY 2
        """.format(predmet_filter=predmet_filter)

        stmt = text(sql)

        stmt = stmt.bindparams(termid=termid)
        stmt = stmt.bindparams(group_id=group_id)

        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getCourseList(self, lname):
        c = Course()
        conn = current_app.ms.db(lname).connect()

        isTeacher = g.user.user_is_teachermid(g.user.mid)
        isAdmin = g.user.user_is_rasdel_admin(
            g.user.mid, "Классный журнал.Администратор"
        )

        mid = g.user.mid

        sql_admin = """select 
        c.cid, 
        concat_ws(' ', c.course_index, c.title) as course,
        mc.name as meta_course_name
        from courses c
        left join meta_course mc on mc.id = c.meta_course 
        order by c.title"""

        sql_teacher = """select 
            c.cid, 
            concat_ws(' ', c.course_index, c.title) as course,
            mc.name as meta_course_name
        from courses c
            left join meta_course mc on mc.id = c.meta_course
            left outer join nnz_schedule sh on sh.cid = c.cid
        where :mid = any(sh.teacher_mid)
        group by c.cid, meta_course_name
        order by c.title"""

        sql_student = """select distinct c.cid, c.title as course, mc.name as meta_course_name
        from courses c
        left join meta_course mc on mc.id = c.meta_course
        inner join nnz_schedule s on s.cid = c.cid
        inner join groupuser gu on gu.gid = s.gid
        where gu.mid = :mid
        order by course"""

        if isAdmin or mid == 1 or mid == 2:
            stmt_admin = text(sql_admin)
            query = conn.execute(stmt_admin)
        elif isTeacher:
            stmt_teacher = text(sql_teacher)
            stmt_teacher = stmt_teacher.bindparams(mid=mid)
            query = conn.execute(stmt_teacher)
        else:
            stmt_student = text(sql_student)
            stmt_student = stmt_student.bindparams(mid=mid)
            query = conn.execute(stmt_student)

        return [dict(r) for r in query.fetchall()]

    def getCourseByYearCorriculumMetaCourse(
            self, lname, syid, idcurriculum, idmetacourse
    ):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT distinct c.cid, concat_ws(' ',c.title, concat(' (',c.course_index,')')) as predmet
        FROM courses c
        JOIN q_demand_disciplines d1 ON d1.cid = c.cid
        JOIN curriculum clm ON clm.q_demand_id = d1.q_demand_id
        JOIN studyyears2curriculum s2c ON s2c.idcurriculum = clm.idcurriculum
        WHERE 1=1
        """

        if syid != 0:
            sql = sql + " AND s2c.syid = :syid "
        if idcurriculum != 0:
            sql = sql + " AND clm.idcurriculum = :idcurriculum "
        if idmetacourse != 0:
            sql = sql + " AND c.meta_course = :idmetacourse "

        sql = (
                sql
                + """
            ORDER BY predmet"""
        )

        stmt = text(sql)
        if syid != 0:
            stmt = stmt.bindparams(syid=syid)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if idmetacourse != 0:
            stmt = stmt.bindparams(idmetacourse=idmetacourse)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}
        if len(result["course"]) == 0:
            return None

        return result

    def getCourseByYearCorriculumMetaCourseCathedra(
            self, lname, syid, idcurriculum, idmetacourse, idcathedra
    ):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT distinct c.cid, concat_ws(' ',c.title, concat(' (',c.course_index,')')) as predmet
        FROM courses c
        JOIN q_demand_disciplines d1 ON d1.cid = c.cid
        JOIN curriculum clm ON clm.q_demand_id = d1.q_demand_id
        JOIN studyyears2curriculum s2c ON s2c.idcurriculum = clm.idcurriculum
        WHERE 1=1
        """

        if syid != 0:
            sql = sql + " AND s2c.syid = :syid "
        if idcurriculum != 0:
            sql = sql + " AND clm.idcurriculum = :idcurriculum "
        if idmetacourse != 0:
            sql = sql + " AND c.meta_course = :idmetacourse "
        if idcathedra != 0:
            sql += " AND c._idcathedra = :idcathedra "

        sql = (
                sql
                + """
            ORDER BY predmet"""
        )

        stmt = text(sql)
        if syid != 0:
            stmt = stmt.bindparams(syid=syid)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if idmetacourse != 0:
            stmt = stmt.bindparams(idmetacourse=idmetacourse)
        if idcathedra != 0:
            stmt = stmt.bindparams(idcathedra=idcathedra)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}
        if len(result["course"]) == 0:
            return None

        return result

    def getAllCourse(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT c.cid, concat_ws(' ', c.title, concat(' (', c.course_index, ')')) as predmet
        FROM (
            SELECT DISTINCT c1.cid, c1.title, c1.course_index
            FROM curriculum clm 
            JOIN qualif_demands q ON q.q_demand_id = clm.q_demand_id 
            JOIN (
                SELECT d1.q_demand_id, d1.cid 
                FROM q_demand_disciplines d1 
                WHERE d1.cid > 0 
                UNION 
                SELECT d2.q_demand_id, c2.cid 
                FROM q_demand_disciplines d2 
                JOIN courses c2 ON c2.dis_group_id = d2.dis_group_id 
                WHERE coalesce(d2.cid, 0) = 0 
                UNION 
                SELECT d3.q_demand_id, c3.cid 
                FROM q_demand_disciplines d3 
                JOIN discipline_groups g3 ON g3.dis_cycle_id = d3.dis_cycle_id 
                JOIN courses c3 ON c3.dis_group_id = g3.dis_group_id 
                WHERE coalesce(d3.cid, 0) = 0 AND coalesce(d3.dis_group_id, 0) = 0 
            ) p ON p.q_demand_id = q.q_demand_id 
            JOIN courses c1 ON c1.cid = p.cid
        ) c
        ORDER BY c.title, c.course_index;
        """

        stmt = text(sql)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["course"]) == 0:
            return None

        return result

    def getCourseByCurriculum(self, lname, curriculumid):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT c.cid, concat_ws(' ',c.title, concat(' (',c.course_index,')')) as predmet
        FROM curriculum clm 
                 JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
                  JOIN ( 
                   SELECT d1.q_demand_id, d1.cid FROM q_demand_disciplines d1 
                   WHERE d1.cid > 0 
                   UNION 
                   SELECT d2.q_demand_id, c2.cid FROM q_demand_disciplines d2 
                    JOIN courses c2 ON c2.dis_group_id=d2.dis_group_id 
                   WHERE coalesce(d2.cid,0) = 0 
                   UNION 
                   SELECT d3.q_demand_id, c3.cid FROM q_demand_disciplines d3 
                    JOIN discipline_groups g3 ON g3.dis_cycle_id=d3.dis_cycle_id 
                     JOIN courses c3 ON c3.dis_group_id=g3.dis_group_id 
                   WHERE coalesce(d3.cid,0) = 0  AND coalesce(d3.dis_group_id,0)=0 
                  ) p ON p.q_demand_id=q.q_demand_id 
                JOIN courses c ON c.cid =p.cid 
                WHERE clm.idcurriculum=:curriculumid 
                ORDER BY  c.title, c.course_index"""

        stmt = text(sql)
        stmt = stmt.bindparams(curriculumid=curriculumid)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["course"]) == 0:
            return None

        return result

    def getAllCourseByCurriculum(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT c.cid, concat_ws(' ', c.title, concat(' (', c.course_index, ')')) as predmet
        FROM (
            SELECT DISTINCT c1.cid, c1.title, c1.course_index
            FROM curriculum clm 
            JOIN qualif_demands q ON q.q_demand_id = clm.q_demand_id 
            JOIN (
                SELECT d1.q_demand_id, d1.cid 
                FROM q_demand_disciplines d1 
                WHERE d1.cid > 0 
                UNION 
                SELECT d2.q_demand_id, c2.cid 
                FROM q_demand_disciplines d2 
                JOIN courses c2 ON c2.dis_group_id = d2.dis_group_id 
                WHERE coalesce(d2.cid, 0) = 0 
                UNION 
                SELECT d3.q_demand_id, c3.cid 
                FROM q_demand_disciplines d3 
                JOIN discipline_groups g3 ON g3.dis_cycle_id = d3.dis_cycle_id 
                JOIN courses c3 ON c3.dis_group_id = g3.dis_group_id 
                WHERE coalesce(d3.cid, 0) = 0 AND coalesce(d3.dis_group_id, 0) = 0 
            ) p ON p.q_demand_id = q.q_demand_id 
            JOIN courses c1 ON c1.cid = p.cid
        ) c
        ORDER BY c.title, c.course_index;
        """

        stmt = text(sql)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["course"]) == 0:
            return None

        return result

    def getCourseListForStudent(self, lname, trmid):
        conn = current_app.ms.db(lname).connect()

        sql = """select c.cid, concat_ws(' ', c.course_index, c.title) as course, mc.name as meta_course_name
		from nnz_weeks w 
		join term_weeks         tw on w.week_id = tw.week_id 
		join nnz_schedule       sh on sh.sh_var_id = w.sh_var_id 
		join courses            c  on sh.cid = c.cid
        left join meta_course   mc on mc.id = c.meta_course
		join groupname          g1 on sh.gid = g1.gid 
		join groupuser          gu on gu.gid = g1.gid 
		where gu.mid = :mid and sh.day_of_week - 1 between weekday(w.wstart_date) and weekday(w.wend_date)  
			and tw.trmid = :trmid
		group by 
			c.cid, 
			c.title, 
			c.course_index,
			mc.name
		order by 
	    c.title"""

        stmt = text(sql)
        stmt = stmt.bindparams(trmid=trmid)
        stmt = stmt.bindparams(mid=g.user.mid)
        query = conn.execute(stmt)

        return [dict(r) for r in query.fetchall()]

    def get_course_by_curriculum_complex_thematic_planning(self, lname, curriculumid):
        conn = current_app.ms.db(lname).connect()

        sql = """
            select c.cid, concat_ws(' ', nullif(c.course_index, ''), c.title) as title 
            from courses c 
              inner join curriculum_detail cd on cd.cid = c.cid 
            where cd.idcurriculum = :curriculumid
            group by c.cid, c.course_index, c.title 
            order by c.title
            """

        stmt = text(sql)
        stmt = stmt.bindparams(curriculumid=curriculumid)
        query = conn.execute(stmt)

        result = {"course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["course"]) == 0:
            return None

        return result
