# LMSAPI/API/Faculty.py
import mimetypes
import os
from typing import Any
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle
from flask import send_from_directory, jsonify
from werkzeug.utils import secure_filename

from LMSAPI.api.Models.CronTasks import CronTaskType, CronTasks
from LMSAPI.api.Models.UserActionLog import UserActionLog
from werkzeug.exceptions import NotFound
from werkzeug.datastructures import FileStorage as FileStorageWerkzeug

# import asyncio


class File:
    def __init__(self, cname):
        self.lname = cname

    def filesExist(self, directory):
        try:
            import os

            filelist = os.listdir(directory)
            for f in filelist:
                if os.path.isdir(os.path.join(directory, f)) != True:
                    return True
            return False
        except:
            current_app.logger.error("listFiles(" + directory + ")")
            return False

    def listFiles(self, directory):
        try:
            import os
            import sys
            import mimetypes
            import datetime

            filelist = os.listdir(directory)
            h = []

            if sys.version_info[0] < 3:
                a = 1
                import urllib
            else:
                import urllib.parse

            for f in filelist:
                if os.path.isdir(os.path.join(directory, f)) != True:
                    filesize = os.path.getsize(os.path.join(directory, f))
                    filetime = datetime.datetime.fromtimestamp(
                        os.path.getctime(os.path.join(directory, f))
                    ).strftime("%d/%m/%Y %H:%M:%S")
                    if sys.version_info[0] < 3:
                        current_app.logger.debug(f)
                        encoded = urllib.quote(f)
                    else:
                        encoded = urllib.parse.quote(f)
                    fdata = {
                        "file": f,
                        "urlencoded": encoded,
                        "type": mimetypes.guess_type(f)[0],
                        "size": filesize,
                        "time": filetime,
                    }

                    h.append(fdata)

            import urllib

            return h

        except Exception as e:
            current_app.logger.error("listFiles(" + directory + ")")
            current_app.logger.debug(e)
            return []

    def getBaseFileDirecotry(self):
        return current_app.ms.fileroot(self.lname)

    def getUserFileDirectory(self, userId):
        return self.getBaseFileDirecotry() + "/People/" + str(userId)

    def getUserFiles(self, userId):
        return self.listFiles(self.getUserFileDirectory(userId))

    def getUserPortfolioDirectory(self, userId):
        return self.getBaseFileDirecotry() + "/portfolio/" + str(userId)

    def getUserPortfolio(self, userId):
        return self.listFiles(self.getUserPortfolioDirectory(userId))

    def createUserPortfolioDirectory(self, userId):
        import os

        if not os.path.exists(self.getUserPortfolioDirectory(userId)):
            os.makedirs(self.getUserPortfolioDirectory(userId))
        return

    def getHomeworkDirectory(self, userId, sheid, instance):
        return (
            self.getBaseFileDirecotry()
            + "/homework_student/"
            + str(userId)
            + "/"
            + str(sheid)
            + "_"
            + str(instance)
        )

    def createHomeworkStudentFileDirectory(self, userId, sheid, instance):
        import os

        if not os.path.exists(self.getHomeworkDirectory(userId, sheid, instance)):
            os.makedirs(self.getHomeworkDirectory(userId, sheid, instance))
        return

    def getHomeworkFiles(self, userId, sheid, instance):
        return self.listFiles(self.getHomeworkDirectory(userId, sheid, instance))

    def homeworkFilesExist(self, userId, sheid, instance):
        return self.filesExist(self.getHomeworkDirectory(userId, sheid, instance))

    def createHomeworkResultFileDirectory(self, userId, sheid, instance):
        import os

        if not os.path.exists(self.getHomeworkResultDirectory(userId, sheid, instance)):
            os.makedirs(self.getHomeworkResultDirectory(userId, sheid, instance))
        return

    def getHomeworkResultDirectory(self, userId, sheid, instance):
        return self.getHomeworkDirectory(userId, sheid, instance) + "/result"

    def getHomeworkResultFiles(self, userId, sheid, instance):
        return self.listFiles(self.getHomeworkResultDirectory(userId, sheid, instance))

    def homeworkResultFilesExist(self, userId, sheid, instance):
        return self.filesExist(self.getHomeworkResultDirectory(userId, sheid, instance))

    def getGroupHomeworkDirectory(self, sheid, instance):
        return (
            self.getBaseFileDirecotry()
            + "/homework/"
            + str(sheid)
            + "_"
            + str(instance)
        )

    def createGroupHomeworkDirectory(self, sheid, instance):
        import os

        if not os.path.exists(self.getGroupHomeworkDirectory(sheid, instance)):
            os.makedirs(self.getGroupHomeworkDirectory(sheid, instance))
        return

    def getGroupHomeworkFiles(self, sheid, instance):
        return self.listFiles(self.getGroupHomeworkDirectory(sheid, instance))

    def groupHomeworkFilesExist(self, sheid, instance):
        return self.filesExist(self.getGroupHomeworkDirectory(sheid, instance))

    def get_journal_lesson_detail_directory(self, sheid, instance):
        return (
            self.getBaseFileDirecotry()
            + "/journal_lesson_detail/"
            + str(sheid)
            + "_"
            + str(instance)
        )

    def create_journal_lesson_detail_directory(self, sheid, instance):
        import os

        if not os.path.exists(
            self.get_journal_lesson_detail_directory(sheid, instance)
        ):
            os.makedirs(self.get_journal_lesson_detail_directory(sheid, instance))
        return

    def get_journal_lesson_detail_files(self, sheid, instance):
        return self.listFiles(self.get_journal_lesson_detail_directory(sheid, instance))

    def journal_lesson_detail_files_exist(self, sheid, instance):
        return self.filesExist(
            self.get_journal_lesson_detail_directory(sheid, instance)
        )

    def get_homework_fact_directory(self, sheid, week_id):
        return (
            self.getBaseFileDirecotry()
            + "/homeworkFact/"
            + str(sheid)
            + "_"
            + str(week_id)
        )

    def create_homework_fact_directory(self, sheid, week_id):
        import os

        if not os.path.exists(self.get_homework_fact_directory(sheid, week_id)):
            os.makedirs(self.get_homework_fact_directory(sheid, week_id))
        return

    def get_homework_fact_files(self, sheid, week_id):
        return self.listFiles(self.get_homework_fact_directory(sheid, week_id))

    def homework_fact_files_exist(self, sheid, week_id):
        return self.filesExist(self.get_homework_fact_directory(sheid, week_id))

    def homework_fact_file_by_filename_exists(self, sheid, week_id, filename):
        """ Проверяет, существует ли файл в указанной директории """
        file_path = os.path.join(self.get_homework_fact_directory(sheid, week_id), filename)
        return os.path.isfile(file_path)

    def get_scholarship_candidates_directory(self, task_id):
        return (
            self.getBaseFileDirecotry()
            + "/scholarship_candidates/"
            + str(task_id)
        )

    def create_scholarship_candidates_directory(self, task_id):
        import os

        if not os.path.exists(
            self.get_scholarship_candidates_directory(task_id)
        ):
            os.makedirs(
                self.get_scholarship_candidates_directory(task_id)
            )
        return

    def get_scholarship_candidates_files(self, task_id):
        return self.listFiles(
            self.get_scholarship_candidates_directory(task_id)
        )

    def get_homework_student_fact_directory(self, user_id, sheid, week_id):
        return (
            self.getBaseFileDirecotry()
            + "/homework_student_Fact/"
            + str(user_id)
            + "/"
            + str(sheid)
            + "_"
            + str(week_id)
        )

    def create_homework_student_fact_directory(self, user_id, sheid, week_id):
        import os

        if not os.path.exists(
            self.get_homework_student_fact_directory(user_id, sheid, week_id)
        ):
            os.makedirs(
                self.get_homework_student_fact_directory(user_id, sheid, week_id)
            )
        return

    def get_homework_student_fact_files(self, user_id, sheid, week_id):
        return self.listFiles(
            self.get_homework_student_fact_directory(user_id, sheid, week_id)
        )

    def homework_student_fact_files_exist(self, user_id, sheid, week_id):
        return self.filesExist(
            self.get_homework_student_fact_directory(user_id, sheid, week_id)
        )

    def homework_student_fact_file_by_filename_exists(self, user_id, sheid, week_id, filename):
        """ Проверяет, существует ли файл в указанной директории """
        file_path = os.path.join(self.get_homework_student_fact_directory(user_id, sheid, week_id), filename)
        return os.path.isfile(file_path)

    def getGroupHomeworkResultDirectory(self, userId, sheid, instance):
        return (
            self.getGroupHomeworkDirectory(sheid, instance) + "/result/" + str(userId)
        )

    def getGroupHomeworkResultFiles(self, userId, sheid, instance):
        return self.listFiles(
            self.getGroupHomeworkResultDirectory(userId, sheid, instance)
        )

    def groupHomeworkResultFilesExist(self, userId, sheid, instance):
        return self.filesExist(
            self.getGroupHomeworkResultDirectory(userId, sheid, instance)
        )

    def createGroupHomeworkResultFileDirectory(self, userId, sheid, instance):
        import os

        if not os.path.exists(
            self.getGroupHomeworkResultDirectory(userId, sheid, instance)
        ):
            os.makedirs(self.getGroupHomeworkResultDirectory(userId, sheid, instance))
        return

    def get_scholarship_candidates_files_storage_directory(self, user_id):
        path = (self.getBaseFileDirecotry() + "/scholarship_candidates_files_storage/" + str(user_id))

        if os.path.exists(path):
            return path
        else:
            return None

    def create_scholarship_candidates_files_directory(self, user_id, chapter):
        base_dir = self.getBaseFileDirecotry()
        path = os.path.join(base_dir, "scholarship_candidates_files_storage", str(user_id), str(chapter))

        if not os.path.exists(path):
            os.makedirs(path, exist_ok=True)
        return path

    def save_scholarship_candidates_files(self, user_id, chapter, file):
        import os

        path = self.create_scholarship_candidates_files_directory(user_id, chapter)
        filename = file.filename.strip()
        save_path = os.path.join(path, filename)
        file.save(save_path)
        return os.path.relpath(path, self.getBaseFileDirecotry())

    def delete_scholarship_candidates_files(self, user_id, chapter, file_name):
        path = os.path.join(self.getBaseFileDirecotry(), "scholarship_candidates_files_storage", str(user_id), str(chapter), file_name)
        if os.path.exists(path):
            try:
                os.remove(path)
                return True
            except Exception as e:
                return False
        else:
            return False

    def get_scholarship_candidates_file(self, user_id, chapter, file_name):
        file_path = os.path.join(self.getBaseFileDirecotry(), "scholarship_candidates_files_storage", str(user_id), str(chapter), file_name)

        if not os.path.exists(file_path):
            return None
        return file_path

    def get_chapter_path(self, mid, chapter):
        return os.path.join(
            self.getBaseFileDirecotry(),
            "scholarship_candidates_files_storage",
            str(mid),
            chapter
        )

    def getStudentProjectTaskDirectory(self, id):
        return self.getBaseFileDirecotry() + "/projects/" + str(id) + "/tasks"

    def createStudentProjectTaskDirectory(self, id):
        import os

        if not os.path.exists(self.getStudentProjectTaskDirectory(id)):
            os.makedirs(self.getStudentProjectTaskDirectory(id))
        return

    def studentProjectTaskDirectoryFilesExist(self, id):
        return self.filesExist(self.getStudentProjectTaskDirectory(id))

    def getStudentProjectTaskDirectoryFiles(self, id):
        return self.listFiles(self.getStudentProjectTaskDirectory(id))

    def getStudentProjectResultDirectory(self, id):
        return self.getBaseFileDirecotry() + "/projects/" + str(id) + "/result"

    def createStudentProjectResultDirectory(self, id):
        import os

        if not os.path.exists(self.getStudentProjectResultDirectory(id)):
            os.makedirs(self.getStudentProjectResultDirectory(id))
        return

    def studentProjectResultDirectoryFilesExist(self, id):
        return self.filesExist(self.getStudentProjectResultDirectory(id))

    def getStudentProjectResultDirectoryFiles(self, id):
        return self.listFiles(self.getStudentProjectResultDirectory(id))

    def getStudentProjectReviewDirectory(self, id, reviewid):
        return (
            self.getBaseFileDirecotry()
            + "/projects/"
            + str(id)
            + "/reviews/"
            + str(reviewid)
        )

    def createStudentProjectReviewDirectory(self, id, reviewid):
        import os

        if not os.path.exists(self.getStudentProjectReviewDirectory(id, reviewid)):
            os.makedirs(self.getStudentProjectReviewDirectory(id, reviewid))
        return

    def studentProjectReviewDirectoryFilesExist(self, id, reviewid):
        return self.filesExist(self.getStudentProjectReviewDirectory(id, reviewid))

    def getStudentProjectReviewDirectoryFiles(self, id, reviewid):
        return self.listFiles(self.getStudentProjectReviewDirectory(id, reviewid))

    def getUserFile(self, userId, filename):
        return ""

    def get_cathedra_directory(self, cathedra_id):
        return self.getBaseFileDirecotry() + "/cathedra/" + str(cathedra_id)

    def get_cathedra_files(self, cathedra_id):
        return self.listFiles(self.get_cathedra_directory(cathedra_id=cathedra_id))

    def get_admission_rules_directory(self):
        return self.getBaseFileDirecotry() + "/Options_Files/Admission_Rules"

    def getAdmissionRulesDirectoryFiles(self):
        return self.listFiles(self.get_admission_rules_directory())

    def getNewsDirectory(self, id):
        return self.getBaseFileDirecotry() + "/posts/" + str(id)

    def getRoomsPhotoDirectory(self, id):
        return os.path.join(self.getBaseFileDirecotry(), "rooms", str(id), "photo")

    def getRoomsPhotoFiles(self, id):
        return self.listFiles(self.getRoomsPhotoDirectory(id))

    def getRoomsPanoramaDirectory(self, id):
        return os.path.join(self.getBaseFileDirecotry(), "rooms", str(id), "panorama")

    def getRoomsPanoramaFiles(self, id):
        return self.listFiles(self.getRoomsPanoramaDirectory(id))

    def getHeroFilesDirectory(self, id):
        return os.path.join(self.getBaseFileDirecotry(), "hero", str(id))

    def getHeroFiles(self, id):
        return self.listFiles(self.getHeroFilesDirectory(id))

    def getJournalPlannerDirectory(self, sheid, week_id):
        return (
            self.getBaseFileDirecotry()
            + "/Planner/"
            + "{sheid}_{week_id}".format(sheid=str(sheid), week_id=week_id)
        )

    def createJournalPlannerDirectory(self, sheid, week_id):
        import os

        if not os.path.exists(self.getJournalPlannerDirectory(sheid, week_id)):
            os.makedirs(self.getJournalPlannerDirectory(sheid, week_id))
        return

    def getJournalPlanner(self, sheid, week_id):
        return self.listFiles(self.getJournalPlannerDirectory(sheid, week_id))

    def get_lesson_type_icons_directory(self, lessontypeid):
        return (
            self.getBaseFileDirecotry()
            + "/lesson_type_icons/"
            + "{lessontypeid}".format(lessontypeid=lessontypeid)
        )

    def create_lesson_type_icons_Directory(self, lessontypeid):
        import os

        if not os.path.exists(self.get_lesson_type_icons_directory(lessontypeid)):
            os.makedirs(self.get_lesson_type_icons_directory(lessontypeid))
        return

    def get_list_lesson_type_icons(self, lessontypeid):
        return self.listFiles(self.get_lesson_type_icons_directory(lessontypeid))

    def get_vsoko_local_act_directory(self, f_doc_hs):
        return (
            self.getBaseFileDirecotry()
            + "/HSDocuments/"
            + "{f_doc_hs}".format(f_doc_hs=f_doc_hs)
        )

    def get_vsoko_local_act_files(self, f_doc_hs):
        return self.listFiles(self.get_vsoko_local_act_directory(f_doc_hs))


    def get_umk_links_directory(self, umk, umk_subtype, link_type=1):
        if link_type == 1:
            return (
                self.getBaseFileDirecotry()
                + "/UMK-LINKS/"
                + str(umk)
                + "/"
                + str(umk_subtype)
            )
        if link_type == 2:
            return (
                self.getBaseFileDirecotry()
                + "/MethodicalFiles/"
                + str(umk)
            )

    def get_umk_links_files(self, umk, umk_subtype):
        return self.listFiles(self.get_umk_links_directory(umk, umk_subtype))

    def create_umk_links_directory(self, umk, umk_subtype):
        import os

        if not os.path.exists(self.get_umk_links_directory(umk, umk_subtype)):
            os.makedirs(self.get_umk_links_directory(umk, umk_subtype))
        return

    def get_personnel_rating_values_directory(self, id):
        return self.getBaseFileDirecotry() + "/personnel_rating_values/" + str(id)

    def get_personnel_rating_values_files(self, id):
        return self.listFiles(self.get_personnel_rating_values_directory(id))

    def create_personnel_rating_values_directory(self, id):
        import os

        if not os.path.exists(self.get_personnel_rating_values_directory(id)):
            os.makedirs(self.get_personnel_rating_values_directory(id))
        return

    def get_xp_applicant_directory(self, xp_key):
        return self.getBaseFileDirecotry() + "/xp_applicant/" + str(xp_key)

    def get_xp_applicant_files(self, xp_key):
        return self.listFiles(self.get_xp_applicant_directory(xp_key))

    def create_xp_applicant_directory(self, xp_key):
        import os

        if not os.path.exists(self.get_xp_applicant_directory(xp_key)):
            os.makedirs(self.get_xp_applicant_directory(xp_key))

    @staticmethod
    def check_for_links(path, files):
        for file in files:
            file["url"] = None
            if ".$link" in file["file"]:
                with open(path + "/" + file["file"], "r") as f:
                    file["url"] = f.readlines()[1].strip("\n")
        return files

    @staticmethod
    def check_for_links_in_files(path, files):
        for file in files:
            if ".$link" in file["file"]:
                file_path = os.path.join(path, file["file"])
                with open(file_path, "r") as f:
                    file_contents = f.readlines()
                    for line in file_contents:
                        if line.strip().startswith("URL="):
                            file["type"] = "url"
                            file["url"] = line.strip().replace("URL=", "")
                            break
                    else:
                        file["type"] = "url"
                        file["url"] = None
            else:
                if file["file"].endswith(".url"):
                    # Для файлов формата .url просто оставляем ссылку в качестве URL
                    file["type"] = "url"
                    # Прочитаем файл .url и возьмем первую строку в качестве ссылки
                    url_file_path = os.path.join(path, file["file"])
                    with open(url_file_path, "r") as f:
                        for line in f:
                            if line.strip().startswith("URL="):
                                url = line.strip().replace("URL=", "")
                                file["url"] = url
                                break
                        else:
                            file["url"] = None
                else:
                    file["type"] = mimetypes.guess_type(file["file"])[
                        0
                    ]  # определение MIME-типа
                    file["url"] = None
        return files

    @staticmethod
    def send_from_directory(
        lname: str,
        file_path: str,
        file_name: str,
        action_source: str,
        login: str,
        user_mid: int,
        ip_address: str,
    ) -> Any:
        error = False
        try:
            return send_from_directory(file_path, file_name)
        except Exception:
            current_app.logger.error("Error sending file from " + file_path)
            error = True
            return jsonify(success=False), 404
        finally:
            if not error:
                UserActionLog.create_log(
                    lname=lname,
                    action_source=action_source,
                    action_type=2,
                    filename=file_name,
                    file_path=file_path,
                    base_file_dir=File(lname).getBaseFileDirecotry(),
                    login=login,
                    user_mid=user_mid,
                    ip_address=ip_address,
                )

    @staticmethod
    def save_file_to_path(
        lname: str,
        submitted_file: FileStorageWerkzeug,
        file_path: str,
        action_source: str,
        login: str,
        user_mid: int,
        ip_address: str,
    ):
        filename = submitted_file.filename
        if not os.path.isfile(os.path.join(file_path, filename)):
            submitted_file.save(os.path.join(file_path, filename))

            UserActionLog.create_log(
                lname=lname,
                action_source=action_source,
                action_type=1,
                filename=filename,
                file_path=file_path,
                base_file_dir=File(lname).getBaseFileDirecotry(),
                login=login,
                user_mid=user_mid,
                ip_address=ip_address,
            )

            available_doc_types = [
                "pdf",
                "doc",
                "docx",
                "xls",
                "xlsx",
                "ppt",
                "pptx",
                "odt",
                "ods",
                "odp",
                "txt",
            ]
            if filename.split(".")[-1].lower() in available_doc_types:
                task_params = {
                    "file_path": os.path.join(file_path, filename),
                    "density": 300,
                    "output_format": "jpg",
                    "output_file_dir": file_path,
                }
                if not CronTasks.check_cron_table(lname):
                    current_app.logger.error("cron table not exists")
                else:
                    CronTasks.create_cron_task(
                        lname, CronTaskType.image_converter, task_params
                    )

            return jsonify(success=True), 201

        return (
            jsonify(
                {
                    "success": False,
                    "error": "File " + filename + " already exist",
                    "fileExist": True,
                }
            ),
            409,
        )

    def get_approved_plan_fact_directory(self, mpid):
        return self.getBaseFileDirecotry() + "/methodplans/" + str(mpid)

    def create_approved_plan_fact_directory(self, mpid):
        import os

        if not os.path.exists(self.get_approved_plan_fact_directory(mpid)):
            os.makedirs(self.get_approved_plan_fact_directory(mpid))
        return

    def get_approved_plan_fact_files(self, mpid):
        return self.listFiles(self.get_approved_plan_fact_directory(mpid))

    def approved_plan_fact_files_exist(self, mpid):
        return self.filesExist(self.get_approved_plan_fact_directory(mpid))

    def get_question_directory(self, id_question):
        return self.getBaseFileDirecotry() + "/Questions/" + str(id_question)

    def get_question_files(self, id_question):
        return self.listFiles(self.get_question_directory(id_question))

    def approved_question_files_exist(self, id_question):
        return self.filesExist(self.get_question_directory(id_question))
