# LMSAPI/API/Faculty.py

from typing import Optional
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from LMSAPI.api.Models.User import User
from flask import current_app, g
import pickle


class Group:
    def __init__(self, cname):
        self.gid = 0
        self.name = ""
        self.lname = cname

    def serialize(self):
        return {"gid": self.gid, "name": self.name}

    def get_group_list_from_redis(self, cathedraid):
        cachedGlist = current_app.ms.redis(self.lname).get("SYSGLIST" + str(cathedraid))
        if cachedGlist is not None:
            glist = pickle.loads(cachedGlist)
            return glist
        return

    def set_group_list_to_redis(self, glist, cathedraid):
        current_app.ms.redis(self.lname).setex(
            "SYSGLIST" + str(cathedraid), 5, pickle.dumps(glist)
        )
        return

    def get_group_from_redis(self, id):
        cachedGlist = current_app.ms.redis(self.lname).get("GR" + str(id))
        if cachedGlist is not None:
            # current_app.logger.debug('Group from cache '+ str(id))
            glist = pickle.loads(cachedGlist)
            return glist
        return

    def set_group_to_redis(self, result):
        current_app.ms.redis(self.lname).setex(
            "GR" + str(result["group"][0]["gid"]), 5, pickle.dumps(result)
        )
        return

    def getGroup(self, lname, id):
        cc = Group(lname)

        result = cc.get_group_from_redis(id)

        if result is not None:
            return result

        conn = current_app.ms.db(lname).connect()

        stmt = text("select * from groupname where gid=:id")

        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        result = {"group": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        if len(result["group"]) == 0:
            return None

        class_teacher = User(lname)

        if result["group"][0]["class_teacher"] is not None:
            class_teacher = class_teacher.get_user_from_sql_id(
                result["group"][0]["class_teacher"]
            )
            if class_teacher is not None:
                result["group"][0]["class_teacher"] = class_teacher.serialize()

        class_teacher2 = User(lname)

        if result["group"][0]["class_teacher2"] is not None:
            class_teacher2 = class_teacher2.get_user_from_sql_id(
                result["group"][0]["class_teacher2"]
            )
            if class_teacher2 is not None:
                result["group"][0]["class_teacher2"] = class_teacher2.serialize()

        if (
            result["group"][0]["syid"] is not None
            and result["group"][0]["f_militaryprofession"] is not None
        ):
            from LMSAPI.api.Models.Educationplan import Educationplan

            ep = Educationplan(lname)
            result["group"][0]["educationplan"] = ep.getEducationPlan(
                result["group"][0]["syid"], result["group"][0]["f_militaryprofession"]
            )
        else:
            result["group"][0]["educationplan"] = None

        if result["group"][0]["syid"] is not None:
            from LMSAPI.api.Models.Studyyear import Studyyear

            sy = Studyyear(lname)
            result["group"][0]["syid"] = sy.getStudyYear(result["group"][0]["syid"])

        if result["group"][0]["f_militaryprofession"] is not None:
            from LMSAPI.api.Models.Militaryprofession import Militaryprofession

            mp = Militaryprofession()
            result["group"][0]["f_militaryprofession"] = mp.getMilitaryProfession(
                lname, result["group"][0]["f_militaryprofession"]
            )

        cc.set_group_to_redis(result)

        return result

    def checkCathedra(self, cathedra):
        conn = current_app.ms.db(self.lname).connect()

        sql = "select cathtype from cathedras where idcathedra = :cathedra"
        stmt = text(sql)
        stmt = stmt.bindparams(cathedra=cathedra)
        query = conn.execute(stmt)

        for row in query:
            return row.cathtype

        return None

    @staticmethod
    def getGroupListByCourse(lname, faculty_id, course, chosen_date):
        conn = current_app.ms.db(lname).connect()
        where = " AND g.idfaculty IS NOT NULL"
        if faculty_id != "0":
            where += " AND g.idfaculty = :faculty_id "
        sql = """
        SELECT g.gid, g.name 
            FROM groupname g 
        JOIN group_history h ON h.gid = g.gid 
		JOIN school_year sy ON h.school_year = sy.xp_key
		    WHERE g.year = :course
		    {where}
		    AND sy.begdate < :chosen_date AND :chosen_date < sy.enddate
        """.format(
            where=where
        )

        stmt = text(sql)
        stmt = stmt.bindparams(course=course)
        stmt = stmt.bindparams(chosen_date=chosen_date)
        if faculty_id != "0":
            stmt = stmt.bindparams(faculty_id=faculty_id)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    @staticmethod
    def get_groups_to_schedule_classes(lname, xp_key, eyid, idfaculty):
        conn = current_app.ms.db(lname).connect()
        where = ""
        eyid_and_join = ""
        sqlargs = {"xp_key": xp_key}
        if idfaculty != 0:
            where += " AND (f.idfaculty=:idfaculty or :idfaculty=0) "
            sqlargs["idfaculty"] = idfaculty
        if eyid != 0:
            eyid_and_join = " and (h.year=:eyid or :eyid=0) "
            sqlargs["eyid"] = eyid
        sql = """
            SELECT g.gid, h.name 
                FROM groupname g 
            JOIN group_history h ON h.gid = g.gid and h.school_year in (select xp_key from school_year where :xp_key in (xp_key,main)) {eyid_and_join}
            JOIN school_year sy ON h.school_year = sy.xp_key
            JOIN educationyears ey ON ey."number"=h.year
            left join cathedras cs on cs.idcathedra=g.idcathedra 
            left join faculty f on f.idfaculty=coalesce(g.idfaculty,cs.faculty)
            where 1=1 {where}
            """.format(
            where=where,
            eyid_and_join=eyid_and_join
        )

        stmt = text(sql)
        query = conn.execute(stmt, sqlargs)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getGroupList(self, lname, cathedra, faculty, syear, eduyear):
        c = Group(lname)

        groupList = None  # c.get_group_list_from_redis (cathedra)

        if groupList is not None:
            return groupList

        conn = current_app.ms.db(lname).connect()

        if eduyear == 0:
            andEduyear = " "
        else:
            andEduyear = " AND g.year = :eduyear "

        if cathedra == 0:
            if faculty == 0:
                sql = """
                select g.gid, h.name 
                from groupname g 
                JOIN group_history h ON h.gid = g.gid AND h.school_year = :syear  
                where g.ideducationlevel > 0  {andEduyear} order by h.name
                """.format(
                    andEduyear=andEduyear
                )

                stmt = text(sql)
                stmt = stmt.bindparams(syear=syear)

                if eduyear != 0:
                    stmt = stmt.bindparams(eduyear=eduyear)

            else:
                sql = """
                select g.gid, h.name 
				from groupname g 
                JOIN group_history h ON h.gid = g.gid AND h.school_year = :syear             
                where g.idfaculty = :faculty """

                sql = sql + andEduyear + " and g.ideducationlevel>0 order by h.name"

                stmt = text(sql)
                stmt = stmt.bindparams(syear=syear)
                stmt = stmt.bindparams(faculty=faculty)
                if eduyear != 0:
                    stmt = stmt.bindparams(eduyear=eduyear)

        else:
            if Group(lname).checkCathedra(cathedra) != 0:
                sql = """
                select g.gid, h.name 
                from groupname g 
				JOIN group_history h ON h.gid = g.gid AND h.school_year = :syear  
				where g.ideducationlevel > 0 {andEduyear} order by h.name
				""".format(
                    andEduyear=andEduyear
                )

                stmt = text(sql)
                stmt = stmt.bindparams(syear=syear)
                if eduyear != 0:
                    stmt = stmt.bindparams(eduyear=eduyear)

            else:
                sql = """select g.gid, h.name 
                     from groupname g
                     JOIN group_history h ON h.gid = g.gid AND h.school_year = :syear
                     where g.ideducationlevel>0
                     and g.idcathedra = :cathedra {andEduyear} 
                     order by h.name""".format(
                    andEduyear=andEduyear
                )
                stmt = text(sql)
                stmt = stmt.bindparams(syear=syear)
                stmt = stmt.bindparams(cathedra=cathedra)
                if eduyear != 0:
                    stmt = stmt.bindparams(eduyear=eduyear)

        # current_app.logger.debug(stmt)
        query = conn.execute(stmt)

        groupList = []

        for row in query:
            rcathedra = Group("")
            rcathedra.gid = row.gid
            rcathedra.name = row.name
            groupList.append(rcathedra)

        c.set_group_list_to_redis(groupList, cathedra)

        return groupList

    def getGroupListForTeacher(self, lname, cid, trimid):
        c = Group(lname)

        groupList = None

        if groupList is not None:
            return groupList

        conn = current_app.ms.db(lname).connect()

        sql = """select distinct  g.gid, g.name, g.* 
                    from term_weeks tw
                    left outer join nnz_weeks w on w.week_id = tw.week_id
                    left outer join nnz_schedule sh on sh.sh_var_id = w.sh_var_id
                    left outer join groupname g on sh.gid = g.gid
                    where g.gid is not null and tw.trmid = :trimid and (g.idcathedra = :cid or :cid = 0)
                    order by g.name"""
        stmt = text(sql)

        if not g.user.user_is_rasdel_admin(
            g.user.mid, "Журнал учета учебных занятий. Администратор"
        ):
            sql = """select distinct  g.gid, g.name, g.* 
                    from term_weeks tw
                    left outer join nnz_weeks w on w.week_id = tw.week_id
                    left outer join nnz_schedule sh on sh.sh_var_id = w.sh_var_id
                    left outer join groupname g on sh.gid = g.gid
                    where g.gid is not null and tw.trmid = :trimid and (g.idcathedra = :cid or :cid = 0) and '{:teacher}' && sh.teacher_mid
                    order by g.name"""
            stmt = text(sql)
            stmt = stmt.bindparams(teacher=g.user.mid)

        stmt = stmt.bindparams(cid=cid)
        stmt = stmt.bindparams(trimid=trimid)

        query = conn.execute(stmt)

        groupList = []

        for row in query:
            group = Group("")
            group.gid = row.gid
            group.name = row.name
            groupList.append(group)

        return groupList

    def get_group_list_variable_stuff(
        self,
        lname: str,
        cathedra_id: Optional[int],
        kurs: int,
        school_year_id: int,
        faculty_id: Optional[int],
    ):
        conn = current_app.ms.db(lname).connect()

        sql = """
        SELECT 
            gn.gid,
            gh.name 
        FROM group_history gh
        JOIN groupname gn ON gn.gid = gh.gid
        WHERE gn.cid = -1 
            AND gh.school_year = :school_year_id 
            AND gn.yeargraduation <> :school_year_id
        """
        if kurs:
            sql += " AND gh.year = :kurs "
        if faculty_id:
            sql += " AND coalesce(gn.idfaculty, c.faculty) = :faculty_id "
        if cathedra_id:
            sql += " AND gn.idcathedra = :cathedra_id "

        sql += "ORDER BY (SUBSTRING(gh.name, '^[0-9]+'))::int , SUBSTRING(gh.name, '[^0-9_].*$')"
        stmt = text(sql)
        stmt = stmt.bindparams(school_year_id=school_year_id)
        if kurs:
            stmt = stmt.bindparams(kurs=kurs)
        if faculty_id:
            stmt = stmt.bindparams(faculty_id=faculty_id)
        if cathedra_id:
            stmt = stmt.bindparams(cathedra_id=cathedra_id)

        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_group_list_journal(
        self,
        lname: str,
        cathedra_id: Optional[int],
        trim_id: int,
        school_year_id: int,
        faculty_id: Optional[int],
    ):
        conn = current_app.ms.db(lname).connect()
        is_admin_filter = (
            ""
            if g.user.user_is_rasdel_admin(
                g.user.mid, "Журнал учета учебных занятий. Администратор"
            )
            else " AND {teacher} = ANY(sh.teacher_mid)".format(teacher=g.user.mid)
        )

        group_filter = """
        AND EXISTS(
            SELECT DISTINCT sh.gid
            FROM vw_schedule sh
            WHERE sh.trmid = {trim_id} {admin_filter}
        )
        """.format(
            trim_id=trim_id, admin_filter=is_admin_filter
        )

        where = group_filter
        where += (
            " AND coalesce(g.idfaculty, c.faculty) = {faculty_id} ".format(
                faculty_id=faculty_id
            )
            if faculty_id
            else ""
        )
        where += (
            " AND g.idcathedra = {cathedra_id} ".format(cathedra_id=cathedra_id)
            if cathedra_id
            else ""
        )

        sql = """
        SELECT
                g.gid,
                h.name

        FROM groupname g
        LEFT JOIN cathedras c ON g.idcathedra = c.idcathedra
        JOIN group_history h ON h.gid = g.gid AND h.school_year = {school_year_id}
        WHERE g.ideducationlevel > 0 {where}
        ORDER BY (SUBSTRING(h.name, '^[0-9]+'))::int , SUBSTRING(h.name, '[^0-9_].*$')
        """.format(
            school_year_id=school_year_id,
            where=where,
        )

        stmt = text(sql)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getAllGroups(self, lname):
        c = Group(lname)

        groupList = None

        if groupList is not None:
            return groupList

        conn = current_app.ms.db(lname).connect()

        sql = """select distinct  g.gid, g.name, g.* 
				from groupname g
				where g.gid is not null 
				order by g.name"""
        stmt = text(sql)

        query = conn.execute(stmt)

        groupList = []

        for row in query:
            group = Group("")
            group.gid = row.gid
            group.name = row.name
            groupList.append(group)

        return groupList

    def getGroupStudents(self, lname, gid):
        c = Group(lname)

        groupList = None

        if groupList is not None:
            return groupList

        conn = current_app.ms.db(lname).connect()

        sql = """select 
        p.mid, lastname, firstname, patronymic
        from people p
        left outer join groupuser gu on p.mid = gu.mid and gu.cid = -1           
        where gu.gid = :gid
        order by lastname, firstname, patronymic"""
        stmt = text(sql)
        stmt = stmt.bindparams(gid=gid)
        query = conn.execute(stmt)

        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return result

    def get_groups_by_role(self, lname, xp_key, idfaculty, idcathedra):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT distinct h.name, gn.gid
            FROM permission2mid p2m  
            JOIN permission_groups pg ON pg.pmid = p2m.pmid 
            JOIN vw_divisions vd ON vd.id = ANY(pg.sdid) 
            JOIN groupname gn ON gn.idcathedra | 536870912 = vd.id  
                              OR gn.idfaculty = vd.id 
                              OR gn.sdid | 268435456 = vd.id 
            JOIN group_history h ON h.gid = gn.gid AND (h.school_year = :xp_key OR 0 = :xp_key)
            WHERE p2m.mid = :mid AND gn.cid = -1 and (gn.idfaculty = :idfaculty OR 0 = :idfaculty) and (gn.idcathedra = :idcathedra OR 0 = :idcathedra)
            """
        stmt = text(sql)
        stmt = stmt.bindparams(mid=g.user.mid)
        stmt = stmt.bindparams(xp_key=xp_key)
        stmt = stmt.bindparams(idfaculty=idfaculty)
        stmt = stmt.bindparams(idcathedra=idcathedra)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_groups_by_faculty_cathedra_year_eyid(self, lname, xp_key, idfaculty, idcathedra, eyid, mid, admin_flag):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT DISTINCT 
                gh.gid, 
                CASE 
                    WHEN :xp_key > 0 THEN gh."name" 
                    ELSE CONCAT(gh."name", ' (', sy."name", ')') 
                END AS group_name
            FROM groupname gn
            JOIN group_history gh ON gn.gid = gh.gid
            JOIN school_year sy ON sy.xp_key = gh.school_year
            LEFT JOIN school_year sy_grad ON sy.xp_key = gn.yeargraduation
            JOIN educationyears ey ON gh."year" = ey.number
            LEFT JOIN cathedras c ON gn.idcathedra = c.idcathedra
            LEFT JOIN faculty f ON f.idfaculty = coalesce(gn.idfaculty, c.faculty)
            WHERE gn.cid = -1
                AND CASE :admin_flag WHEN 0 THEN ((gn.idfaculty IS NOT NULL) OR (gn.idcathedra IS NOT NULL)) ELSE 1 = 1 END
                AND gh.school_year in (select xp_key from school_year where  :xp_key in (xp_key,main))
                AND CASE :idfaculty WHEN 0 THEN (1 = 1) ELSE gn.idfaculty = :idfaculty END
                AND CASE :idcathedra WHEN 0 THEN (1 = 1) ELSE gn.idcathedra = :idcathedra END
                AND CASE :eyid WHEN -1 THEN (1 = 1) ELSE gh."year" = :eyid END
                {permission_filter}
            ORDER BY group_name;
            """

        permission_filter = ""
        if not admin_flag:
            permission_filter = """
            AND (coalesce(gn.idfaculty,c.faculty) IN (
                SELECT DISTINCT f.idfaculty
                FROM permission2mid p2m
                JOIN permission_groups pg ON p2m.pmid = pg.pmid
                JOIN faculty f ON f.idfaculty = ANY(pg.sdid)
                WHERE mid = :mid)
            OR gn.idcathedra IN (
                SELECT DISTINCT c.idcathedra
                FROM permission2mid p2m
                JOIN permission_groups pg ON p2m.pmid = pg.pmid
                JOIN cathedras c ON c.idcathedra | 536870912 = ANY(pg.sdid)
                WHERE mid = :mid)
            OR gn.sdid IN (
                SELECT DISTINCT d.sdid
                FROM permission2mid p2m
                JOIN permission_groups pg ON p2m.pmid = pg.pmid
                JOIN struct_divisions d ON d.sdid | 268435456 = ANY(pg.sdid)
                WHERE mid = :mid)
            OR :mid IN (gn.class_teacher,gn.class_teacher2) 
            )
            """
        sql = sql.format(permission_filter=permission_filter)

        stmt = text(sql)
        stmt = stmt.bindparams(xp_key=int(xp_key))
        stmt = stmt.bindparams(idfaculty=int(idfaculty))
        stmt = stmt.bindparams(idcathedra=int(idcathedra))
        stmt = stmt.bindparams(eyid=int(eyid))
        if not admin_flag:
            stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(admin_flag=admin_flag)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_groups_by_admin(self, lname, xp_key, idfaculty, idcathedra):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT distinct h.name, gn.gid
            FROM groupname gn
            JOIN group_history h ON h.gid = gn.gid AND (h.school_year = :xp_key OR 0 = :xp_key)
            WHERE gn.cid = -1 and (gn.idfaculty = :idfaculty OR 0 = :idfaculty) and (gn.idcathedra = :idcathedra OR 0 = :idcathedra)
            """
        stmt = text(sql)
        stmt = stmt.bindparams(xp_key=xp_key)
        stmt = stmt.bindparams(idfaculty=idfaculty)
        stmt = stmt.bindparams(idcathedra=idcathedra)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_group_students_by_period(self, begdate, enddate, gid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT public.xp_fill_groupuser_period(:begdate, :enddate, :gid);

        SELECT
            gp.mid,
            p.lastname,
            p.firstname,
            p.patronymic
        FROM groupuser_period gp
        JOIN people p ON p.mid = gp.mid
        WHERE cid = -1;
        """
        stmt = text(sql)
        stmt = stmt.bindparams(begdate=begdate, enddate=enddate, gid=gid)
        query = conn.execute(stmt)

        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return result

    def get_groups_journal_of_accounting_of_training_sessions(
            self, mid: int, is_admin: int, xp_key: int, trmid: int, idcathedra=0, idfaculty=0):
        """
            Получение групп для режима "Журнал учета учебных занятий"
        """
        conn = current_app.ms.db(self.lname).connect()
        group_filter = ""

        if is_admin:
            admin_filter = ""
        else:
            admin_filter = " AND (({mid} = ANY(sh.teacher_mid)) OR (sh.cid IN (SELECT cid FROM teachers WHERE mid = {mid} AND cid > 0))) ".format(mid=mid)
        group_filter = """
        AND h.gid IN (
            SELECT v.main_gid 
            FROM vw_schedule v
            JOIN groupname gn ON gn.gid=v.main_gid
            JOIN nnz_schedule sh ON sh.sheid=v.sheid
        WHERE v.school_year={xp_key} AND v.std_trmid = {trmid} {admin_filter})
        """.format(xp_key=xp_key, trmid=trmid, admin_filter=admin_filter)

        if idcathedra == 0:  # Если выбраны все кафедры или список кафедр пустой
            if idfaculty == 0:  # Если, при этом, выбраны все факультеты - показывает все группы
                sql = """
                SELECT g.gid, h.name
                FROM groupname g
                JOIN group_history h ON h.gid = g.gid
                    AND h.school_year IN (
                            SELECT xp_key 
                            FROM school_year 
                            WHERE {xp_key} IN (xp_key, main)
                        )
                WHERE g.cid = -1 AND g.ideducationlevel > 0 {group_filter}
                ORDER BY (substring(h.name, '^[0-9]+'))::bigint , substring(h.name, '[^0-9_].*$')
                """.format(xp_key=xp_key, group_filter=group_filter)
            else:  # Иначе - группы факультета
                sql = """
                SELECT g.gid, h.name
                FROM groupname g
                JOIN group_history h ON h.gid = g.gid
                    AND h.school_year IN (
                            SELECT xp_key 
                            FROM school_year 
                            WHERE {xp_key} IN (xp_key, main)
                        )
                LEFT JOIN cathedras c ON (g.idcathedra = c.idcathedra)
                WHERE g.cid = -1 AND g.ideducationlevel > 0 
                AND coalesce(g.idfaculty, c.faculty) = {idfaculty} {group_filter}
                ORDER BY (substring(h.name, '^[0-9]+'))::bigint , substring(h.name, '[^0-9_].*$')
                """.format(xp_key=xp_key, idfaculty=idfaculty, group_filter=group_filter)
        else:
            sql = """
            SELECT g.gid, h.name
            FROM groupname g
            JOIN group_history h ON h.gid = g.gid
                AND h.school_year IN (
                        SELECT xp_key 
                        FROM school_year 
                        WHERE {xp_key} IN (xp_key,main)
                    )
            JOIN cathedras c ON (g.idcathedra = c.idcathedra) AND c.idcathedra={idcathedra}
            WHERE g.cid = -1 AND g.ideducationlevel > 0
                AND (coalesce(g.idfaculty, c.faculty) = {idfaculty} or {idfaculty}<=0) {group_filter}
            ORDER BY (substring(h.name, '^[0-9]+'))::bigint , substring(h.name, '[^0-9_].*$')
            """.format(xp_key=xp_key, idcathedra=idcathedra, idfaculty=idfaculty, group_filter=group_filter)
        stmt = text(sql)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_groups_military_professional_portrait_of_a_student(
            self, year_id, faculty_id, military_profession_id
    ):
        """
            Получение групп для режима "Военно-профессиональный портрет обучающегося"
        """
        conn = current_app.ms.db(self.lname).connect()

        join = ""
        where = ""
        sqlargs = {}

        if year_id:
            where += " AND gh.school_year = :year_id "
            sqlargs["year_id"] = year_id

        if faculty_id:
            where += " AND gn.idfaculty = :faculty_id "
            sqlargs["faculty_id"] = faculty_id

        if military_profession_id:
            join += " JOIN militaryprofession mp ON mp.mpid = gn.f_militaryprofession "
            where += " AND mp.mpid = :military_profession_id "
            sqlargs["military_profession_id"] = military_profession_id

        sql = """
        SELECT gn.gid, gh.name
        FROM groupname gn
        JOIN group_history gh ON gh.gid = gn.gid 
        {join}
        WHERE 1 = 1 {where}
        """.format(join=join, where=where)

        stmt = text(sql)
        query = conn.execute(stmt, sqlargs)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
