from flask import Flask, abort, request, jsonify, g, url_for,current_app
from sqlalchemy import create_engine
from sqlalchemy.sql import text

import hashlib
import sys
import pickle

class Links():

    def __init__(self,cname):        
        self.lname = cname

    def get_link_image(self,id):

        conn = current_app.ms.db(self.lname).connect()
        
        stmt = text("select icon from ios_links where id=:id")
        stmt = stmt.bindparams(id=id)    
        query = conn.execute(stmt)

        for row in query:
            if row[0] is not None:
                if sys.version_info[0] < 3:
                    file = row[0]
                else:
                    file = row[0].tobytes()
                contentstr = file
                return contentstr

        return None

    def get_links(self):
        sql="""select id,title,link from ios_links"""
        conn = current_app.ms.db(self.lname).connect()
        stmt = text(sql)        
        query = conn.execute(stmt)

        qresult  = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        if(len(qresult)>0):

            for link in qresult:
                link['icon'] = request.path + "/" + str(link['id'])

            return qresult

        return []