# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Studyyear:

    def __init__(self,cname):
        self.lname = cname
   
    def getListFromRedis(self):
        cachedClist = current_app.ms.redis(self.lname).get("SYSSYLIST")
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setListToRedis(self,ylist):
        current_app.ms.redis(self.lname).setex("SYSSYLIST",5,pickle.dumps(ylist))
        return

    def getStudyYearList(self):

        studyyearList = self.getListFromRedis()
        
        if studyyearList is not None:
            return studyyearList

        conn = current_app.ms.db(self.lname).connect()
        
        stmt = text("select * from studyyears order by name")
   
        query = conn.execute(stmt)

        studyyearList = {'studyYear': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

        self.setListToRedis(studyyearList)

        return studyyearList

    def getStudyYear(self,id):

        conn = current_app.ms.db(self.lname).connect()
        
        stmt = text("select * from studyyears where syid=:id")
        stmt = stmt.bindparams(id=id)    
        query = conn.execute(stmt)

        studyyearList = {'studyYear': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

        if studyyearList['studyYear'][0]['school_year'] is not None:
            from LMSAPI.api.Models.Schoolyear import Schoolyear
            sy = Schoolyear(self.lname)
            studyyearList['studyYear'][0]['school_year'] = sy.getSchoolYear(studyyearList['studyYear'][0]['school_year'])
      
        return studyyearList