# LMSAPI/API/Faculty.py
import os
from typing import Union

from sqlalchemy import create_engine
from sqlalchemy.sql import text

import config
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.User import User
from flask import current_app
import pickle


class TrainingDirection:
    def __init__(self, cname):
        self.lname = cname

    def get_all_dirs(self):
        sql = (
            """
            SELECT training_direct_id, training_index, training_direct, qualification
            FROM training_directions;
            """
        )

        stmt = text(sql)

        return self.return_result(stmt, self.lname)

    @staticmethod
    def get_train_dir(lname: str, dir_id: int) -> Union[bool, dict]:
        sql = """
            SELECT *
            FROM training_directions WHERE training_direct_id={dir_id};
        """.format(dir_id=dir_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_train_dir(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
                INSERT INTO training_directions(training_direct, "Gen_GOS", training_index, qualification, okso,
                    "parentGroupName", science_spec)
                VALUES('{training_direct}', '{Gen_GOS}', '{training_index}', '{qualification}', {okso}, 
                    '{parentGroupName}', {science_spec}) RETURNING *
            """.format(training_direct=data.get("training_direct"),
                       Gen_GOS=data.get("Gen_GOS"),
                       training_index=data.get("training_index")
                       if data.get("training_index") else "null",
                       qualification=data.get("qualification"),
                       okso=data.get("okso")
                       if data.get("okso") else "null",
                       parentGroupName=data.get("parentGroupName")
                       if data.get("parentGroupName") else "null",
                       science_spec=data.get("science_spec")
                       if data.get("science_spec") else "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def update_train_dir(lname: str, data: dict, train_dir_id: int) -> Union[bool, dict]:
        sql = """
                UPDATE training_directions SET training_direct='{training_direct}', "Gen_GOS"='{Gen_GOS}', 
                    training_index='{training_index}', qualification='{qualification}', okso={okso},
                    "parentGroupName"='{parentGroupName}', science_spec={science_spec}
                WHERE training_direct_id={train_dir_id} RETURNING *
                """.format(training_direct=data.get("training_direct"),
                           Gen_GOS=data.get("Gen_GOS"),
                           training_index=data.get("training_index")
                           if data.get("training_index") else "null",
                           qualification=data.get("qualification"),
                           okso=data.get("okso")
                           if data.get("okso") else "null",
                           parentGroupName=data.get("parentGroupName")
                           if data.get("parentGroupName") else "null",
                           science_spec=data.get("science_spec")
                           if data.get("science_spec") else "null",
                           train_dir_id=train_dir_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def return_result(stmt, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
