import json
import os
import threading
import uuid
import zipfile

from flask import Blueprint, jsonify, request, g, current_app
from flask_cors import CORS

from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.Applicant import Applicant
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.access_utils import user_permission_modes


applicant_api = Blueprint("applicant_api", __name__)

CORS(applicant_api)


@applicant_api.route(
    "/lms/api/v1.0/<lname>/applicant", methods=["GET"]
)
@auth.login_required
@user_permission_modes("Справочники", "Кандидаты", ["Нет"])
def get_applicants(lname):
    applicants = Applicant(lname).get_import_applicants(request.args)
    count = Applicant(lname).get_count_import_applicants(request.args)
    result = {"count": count, "applicants": applicants}
    return jsonify(result)