from flask import Flask,jsonify, request, current_app, send_from_directory, Response, g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Company   import Company
from LMSAPI.api.Models.File import File
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

company_api = Blueprint('company_api', __name__)

CORS(company_api)

@company_api.route('/lms/api/v1.0/<lname>/company', methods=['GET'])
def getCompany(lname):
        """Get the company information"""
        try:
                result = Company().getCompany(lname)
                if result is None:
                        return jsonify(success=False),404

                return jsonify(result)

        except NameError:
                return "ERROR: No such company: " + lname,404
        else:
                return "Server error",500

@company_api.route('/lms/api/v1.0/<lname>/chiefs', methods=['GET'])
def getСhiefs(lname):
        result = Company().getСhiefs(lname)
        if result is None:
                return jsonify(success=False),404
        return jsonify(result)
                    

@company_api.route('/lms/api/v1.0/<lname>/company/dep_logo', methods=['GET'])
def getDEPLogo(lname):
        """GET department logotype"""
        
        result = Company().getImage(lname,"Dep_Logo")

        if result is None:
                return jsonify(success=False),404

        response = Response(str(id))
        response.content_type = 'image/jpeg'
        response.headers['Content-disposition'] = 'attachment; filename = ' +str(id)+ '.jpg'
        response.headers['Cache-control'] = 'max-age=86400'
        response.content_length = len(result)
        response.data = result
        
        return response

@company_api.route('/lms/api/v1.0/<lname>/company/gou_logo', methods=['GET'])
def getGOULogo(lname):
        """GET GOU logotype"""

        result = Company().getImage(lname,"GOU_Logo_PNG")

        if result is None:                
                result = Company().getImage(lname,"GOU_Logo")

        if result is None:                
                return jsonify(success=False),404

        response = Response(str(id))
        response.content_type = 'image/png'
        response.headers['Content-disposition'] = 'attachment; filename = ' +str(id)+ '.png'
        response.headers['Cache-control'] = 'max-age=86400'
        response.content_length = len(result)
        response.data = result
        
        return response

@company_api.route('/lms/api/v1.0/<lname>/company/admissionrules', methods=['GET'])
def getAdmissionRules(lname):
    path = File(lname).get_admission_rules_directory()
    result = File(lname).getAdmissionRulesDirectoryFiles()
    if result is None:
        return jsonify(success=False), 404

    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name=result[0]['file'],
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )

    
@company_api.route('/lms/api/v1.0/<lname>/company/history', methods=['GET'])
def getHistoryList(lname):
    newsList = Company().getHistoryList(lname, request.args)
    
    if newsList is None:
        return jsonify(success=False),404

    return jsonify(newsList)

@company_api.route('/lms/api/v1.0/<lname>/company/history/<int:id>/parts', methods=['GET'])
def getHistoryPartsList(lname, id):
    newsPartsList = Company().getHistoryPartsList(lname, id)
    
    if newsPartsList is None:
        return jsonify(success=False),404

    return jsonify(newsPartsList)

@company_api.route('/lms/api/v1.0/<lname>/company/history/<int:id>/image', methods=['GET'])
def getHistoryImage(lname, id):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404
    
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='picture.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )


@company_api.route('/lms/api/v1.0/<lname>/company/history/<int:id>/<int:partid>/image', methods=['GET'])
def getHistoryPartImage(lname, id, partid):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404
    
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='part_picture_' + str(partid) + '.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )


@company_api.route('/lms/api/v1.0/<lname>/company/information', methods=['GET'])
def getInformationList(lname):
    newsList = Company().getInformationList(lname, request.args)
    
    if newsList is None:
        return jsonify(success=False),404

    return jsonify(newsList)

@company_api.route('/lms/api/v1.0/<lname>/company/information/<int:id>/parts', methods=['GET'])
def getInformationPartsList(lname, id):
    newsPartsList = Company().getInformationPartsList(lname, id)
    
    if newsPartsList is None:
        return jsonify(success=False),404

    return jsonify(newsPartsList)


@company_api.route('/lms/api/v1.0/<lname>/company/information/<int:id>/image', methods=['GET'])
def getInformationImage(lname, id):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404
    
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='picture.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )


@company_api.route('/lms/api/v1.0/<lname>/company/information/<int:id>/<int:partid>/image', methods=['GET'])
def getInformationPartImage(lname, id, partid):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404
    
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='part_picture_' + str(partid) + '.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )