from typing import Union, Tuple, Any

from flask import jsonify, request
from flask import Blueprint
from flask_cors import CORS

from LMSAPI.api.Models.Demands import Demands
from LMSAPI.api.Views.TokenAPI import auth

demands_api = Blueprint('demands_api', __name__)

CORS(demands_api)

@demands_api.route('/lms/api/v1.0/<lname>/demands', methods=['GET'])
@auth.login_required
def get_all_demands(lname: str) -> Union[Tuple[Any, int], list]:
    res = Demands().get_all_demands(lname)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)

@demands_api.route('/lms/api/v1.0/<lname>/curr_demands/<int:demand_id>', methods=['GET'])
@auth.login_required
def get_curr_demands(lname: str, demand_id: int) -> Union[Tuple[Any, int], list]:
    res = Demands().get_curr_demands(lname, demand_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@demands_api.route('/lms/api/v1.0/<lname>/both_demands/<int:demand_id>', methods=['GET'])
@auth.login_required
def get_both_demands(lname: str, demand_id: int) -> Union[Tuple[Any, int], list]:
    res = Demands().get_both_demands(lname, demand_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify()


@demands_api.route('/lms/api/v1.0/<lname>/demands', methods=['POST'])
@auth.login_required
def add_demands(lname: str) -> Union[Tuple[Any, int], list]:
    res = Demands().add_demands(lname, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)

