from flask import Flask, jsonify, request, current_app, g
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint

from LMSAPI.api.Models.MetaCourse import MetaCourse
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

meta_course_api = Blueprint("meta_course_api", __name__)

CORS(meta_course_api)


@meta_course_api.route(
    "/lms/api/v1.0/<lname>/metacourse/<int:syid>/<int:idcurriculum>/<int:cid>",
    methods=["GET"],
)
@auth.login_required
def getMetaCourseByCourse(lname, syid, idcurriculum, cid):
    if syid == 0 and idcurriculum == 0 and cid == 0:
        result = MetaCourse().getAllMetaCourse(lname)
    else:
        result = MetaCourse().getMetaCourseByYearCorriculumCourse(
            lname, syid, idcurriculum, cid
        )

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@meta_course_api.route(
    "/lms/api/v1.0/<lname>/metacourse/<int:idcathedra>",
    methods=["GET"],
)
@auth.login_required
def getMetaCourseByСathedra(lname, idcathedra):
    result = MetaCourse().getMetaCourseByСathedra(lname, idcathedra)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@meta_course_api.route(
    "/lms/api/v1.0/<lname>/lessonplans/metacourses",
    methods=["GET"],
)
@auth.login_required
def get_lesson_plans_metacourses(lname):
    """GET with Course IDs or Curriculum IDs to get list of metacourses"""
    idcurriculum = request.args.get("idcurriculum", default=0, type=int)
    syid = request.args.get("syid", default=0, type=int)
    cid = request.args.get("cid", default=0, type=int)

    result = MetaCourse().get_lesson_plans_metacourses(lname, idcurriculum, syid, cid)
    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)
