from flask import Flask,jsonify, request, send_from_directory, current_app, g
from sqlalchemy import create_engine
from flask import Blueprint
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.News import News
from LMSAPI.api.Models.File import File
from flask_cors import CORS

news_api = Blueprint('news_api', __name__)

CORS(news_api)

@news_api.route('/lms/api/v1.0/<lname>/news', methods=['GET'])
def getNewsList(lname):
    newsList = News().getNewsList(lname, request.args)
    
    if newsList is None:
        return jsonify(success=False),404

    return jsonify(newsList)

@news_api.route('/lms/api/v1.0/<lname>/news/<int:id>/parts', methods=['GET'])
def getNewsPartsList(lname, id):
    newsPartsList = News().getNewsPartsList(lname, id)
    
    if newsPartsList is None:
        return jsonify(success=False),404

    return jsonify(newsPartsList)


@news_api.route('/lms/api/v1.0/<lname>/news/<int:id>/image', methods=['GET'])
def getNewsImage(lname, id):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='picture.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )


@news_api.route('/lms/api/v1.0/<lname>/news/<int:id>/<int:partid>/image', methods=['GET'])
def getNewsPartImage(lname, id, partid):
    path = File(lname).getNewsDirectory(id)
    if path is None:
        return jsonify(success=False), 404

    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name='part_picture_' + str(partid) + '.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )