from flask import jsonify
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.PreparationStructure import PreparationStructure
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

preparation_structure_api = Blueprint('preparation_structure_api', __name__)

CORS(preparation_structure_api)


@preparation_structure_api.route('/lms/api/v1.0/<lname>/preparation_structure', methods=['GET'])
@auth.login_required
def getPreparationStructure(lname):
    """GET to generate a list of endpoints and their docstrings"""
    result = PreparationStructure(lname).getPS()


    return jsonify(result)
