import os
from flask import current_app
from sqlalchemy import text

from LMSAPI.api.Models.File import File

class CombatTrainingTasks:

    @staticmethod
    def get_combat_training_tasks(lname: str, limit: int, offset: int, count: bool):
        conn = current_app.ms.db(lname).connect()
        file_instance = File(lname)

        if count:
            sql = """
            SELECT 
                    count(postid) 

            FROM posts3 
            WHERE cid = -50
            """
            query = conn.execute(text(sql))
            return query.first().count

        limit = " LIMIT {limit}".format(limit=limit) if limit else ""
        offset = " OFFSET {offset}".format(offset=offset) if offset else ""

        sql = """
        SELECT 
                p.postid,
                p.posted,
                p.name,
                p.text,
                p.mid,
                COALESCE(
                    json_agg(
                        json_build_object(
                            'post_part_id', pp.id,
                            'header', pp.header,
                            'content', pp.content,
                            'sorting', pp.sorting
                        )
                        ORDER BY pp.sorting
                    ) FILTER (WHERE pp.id IS NOT NULL),
                    '[]'
                )                                                   parts

        FROM posts3 p
        LEFT JOIN post_parts pp ON pp.post = p.postid
        WHERE cid = -50
        GROUP BY p.postid
        {limit}
        {offset}
        """.format(limit=limit, offset=offset)

        query = conn.execute(text(sql))
        result = [dict(r) for r in query]

        for r in result:
            files = file_instance.listFiles(file_instance.getNewsDirectory(r["postid"]))
            file = [file for file in files if file.get("file") and file.get("file") == "picture.png"]
            r["file"] = file[0] if file else None

            for p in r["parts"]:
                file = [
                    file 
                    for file in files 
                    if file.get("file") and file.get("file").split(".")[0][-1] == str(p.get("post_part_id"))
                ]
                p["file"] = file[0] if file else None

        return result

    @staticmethod
    def get_combat_training_task_image_path(lname: str, post_id: int):
        file = File(lname)
        return file.getNewsDirectory(post_id)