from typing import Union, List, Dict, Any

from flask import current_app
from sqlalchemy import text


class Disciplines:
    def __init__(self, cname):
        self.lname = cname

    # FOR BLOCKS
    @staticmethod
    def create_block(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
            INSERT INTO discipline_blocks(index, name, block_type, sorting)
            VALUES('{index}', '{name}', {block_type}, {sorting}) RETURNING *
        """.format(index=data.get("index"), name=data.get("name"),
                   block_type=data.get("block_type"), sorting=data.get("sorting") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_blocks(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += "('{index}', '{name}', {block_type}, {sorting})" \
                .format(index=data.get("index"), name=data.get("name"),
                        block_type=data.get("block_type"), sorting=data.get("sorting") or "null")
            if data != data_list[-1]:
                values += ", "

        sql = """
            INSERT INTO discipline_blocks(index, name, block_type, sorting)
            VALUES {values} RETURNING *
        """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_discipline_block(lname: str, block_id: int) -> Union[bool, dict]:
        sql = """
            SELECT * FROM discipline_blocks
            WHERE id={block_id}""".format(block_id=block_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_disciplines_many_blocks(lname: str) -> Union[bool, list]:
        sql = """SELECT * FROM discipline_blocks ORDER BY id"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_discipline_block(lname: str, block_id: int, data: dict) -> Union[bool, dict]:
        sql = """
                UPDATE discipline_blocks SET index='{index}', name='{name}',
                block_type={block_type}, sorting={sorting}
                WHERE id={block_id} RETURNING *""".format(index=data.get("index"), name=data.get("name"),
                                                          block_type=data.get("block_type"),
                                                          sorting=data.get("sorting") or "null",
                                                          block_id=block_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    # FOR CYCLES

    @staticmethod
    def create_cycle(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
                INSERT INTO discipline_cycles(dis_cycle, dis_cycle_descript, dis_cycle_index,
                dis_cycle_sort, is_prof, discipline_type, block, hide)
                VALUES('{dis_cycle}', '{dis_cycle_descript}', '{dis_cycle_index}',
                {dis_cycle_sort}, {is_prof}, {discipline_type},
                {block}, {hide}) RETURNING *
            """.format(dis_cycle=data.get("dis_cycle"), dis_cycle_descript=data.get("dis_cycle_descript"),
                       dis_cycle_index=data.get("dis_cycle_index"), dis_cycle_sort=data.get("dis_cycle_sort") or "null",
                       is_prof=data.get("is_prof") or False, discipline_type=data.get("discipline_type") or "null",
                       block=data.get("block") or "null", hide=data.get("hide") or False)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_cycles(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += "('{dis_cycle}', '{dis_cycle_descript}', '{dis_cycle_index}',\
                {dis_cycle_sort}, {is_prof}, {discipline_type},\
                {block}, {hide})" \
                .format(dis_cycle=data.get("dis_cycle"), dis_cycle_descript=data.get("dis_cycle_descript"),
                        dis_cycle_index=data.get("dis_cycle_index"),
                        dis_cycle_sort=data.get("dis_cycle_sort") or "null",
                        is_prof=data.get("is_prof") or False, discipline_type=data.get("discipline_type") or "null",
                        block=data.get("block") or "null", hide=data.get("hide") or False)
            if data != data_list[-1]:
                values += ", "

        sql = """
                INSERT INTO discipline_cycles(dis_cycle, dis_cycle_descript, dis_cycle_index,
                dis_cycle_sort, is_prof, discipline_type, block, hide)
                VALUES {values} RETURNING *
            """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_discipline_cycle(lname: str, cycle_id: int) -> Union[bool, dict]:
        sql = """
                SELECT * FROM discipline_cycles
                WHERE dis_cycle_id={cycle_id}""".format(cycle_id=cycle_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_disciplines_many_cycles(lname: str) -> Union[bool, list]:
        sql = """SELECT * FROM discipline_cycles ORDER BY dis_cycle_id"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_discipline_cycle(lname: str, cycle_id: int, data: dict) -> Union[bool, dict]:
        sql = """
                UPDATE discipline_cycles SET dis_cycle='{dis_cycle}', dis_cycle_descript='{dis_cycle_descript}',
                dis_cycle_index='{dis_cycle_index}', dis_cycle_sort={dis_cycle_sort}, is_prof={is_prof},
                discipline_type={discipline_type}, block={block}, hide={hide}
                WHERE dis_cycle_id={cycle_id} RETURNING *""" \
            .format(dis_cycle=data.get("dis_cycle"), dis_cycle_descript=data.get("dis_cycle_descript"),
                    dis_cycle_index=data.get("dis_cycle_index"), dis_cycle_sort=data.get("dis_cycle_sort") or "null",
                    is_prof=data.get("is_prof") or False, discipline_type=data.get("discipline_type") or "null",
                    block=data.get("block") or "null", hide=data.get("hide") or False, cycle_id=cycle_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    # FOR GROUPS

    @staticmethod
    def create_group(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
                    INSERT INTO discipline_groups(discipline_group, discipline_index, dis_cycle_id,
                    part, hide, sorting)
                    VALUES('{discipline_group}', '{discipline_index}', {dis_cycle_id},
                    {part}, {hide}, {sorting}) RETURNING *
            """.format(discipline_group=data.get("discipline_group"), discipline_index=data.get("discipline_index"),
                       dis_cycle_id=data.get("dis_cycle_id"), part=data.get("part") or "null",
                       hide=data.get("hide") or False, sorting=data.get("sorting") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_groups(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += "('{discipline_group}', '{discipline_index}', {dis_cycle_id},\
                    {part}, {hide}, {sorting})" \
                .format(discipline_group=data.get("discipline_group"), discipline_index=data.get("discipline_index"),
                        dis_cycle_id=data.get("dis_cycle_id"), part=data.get("part") or "null",
                        hide=data.get("hide") or False, sorting=data.get("sorting") or "null")
            if data != data_list[-1]:
                values += ", "

        sql = """
                INSERT INTO discipline_groups(discipline_group, discipline_index, dis_cycle_id,
                    part, hide, sorting)
                VALUES {values} RETURNING *
            """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def get_discipline_group(lname: str, group_id: int) -> Union[bool, dict]:
        sql = """
                SELECT * FROM discipline_groups
                WHERE dis_group_id={group_id}""".format(group_id=group_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_disciplines_many_groups(lname: str) -> Union[bool, list]:
        sql = """SELECT * FROM discipline_groups ORDER BY dis_group_id"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_discipline_group(lname: str, group_id: int, data: dict) -> Union[bool, dict]:
        sql = """
                    UPDATE discipline_groups SET discipline_group='{discipline_group}',
                        discipline_index='{discipline_index}', dis_cycle_id={dis_cycle_id}, part={part},
                        hide={hide}, sorting={sorting}
                    WHERE dis_group_id={group_id}
                    RETURNING *""" \
            .format(discipline_group=data.get("discipline_group"), discipline_index=data.get("discipline_index"),
                    dis_cycle_id=data.get("dis_cycle_id"), part=data.get("part") or "null",
                    hide=data.get("hide") or False, sorting=data.get("sorting") or "null", group_id=group_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)
