import decimal
from typing import Union

from flask import current_app
from sqlalchemy import text


class EducationDirections:
    @staticmethod
    def create_edu_dir(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
        INSERT INTO edu_direction(training_direct_id, dir_reg_num, dir_reg_date, code, p_mastering_m,
            labour_intensity, dir_state, "Gen_GOS", hours_total, time_of_development, theoretical_training,
            sessions_count, study_training, practical_training, state_sertification, holidays, kt_time,
            teaching_load, auditorium_min, auditorium_max, vacation_time, vacation_time_w, program_name,
            "EduForm", description, p_mastering_w, by_competences, specialization, prefix_comp,
            f_education_profiles, doctors_all, doctors_pro, equal_all, ranked_adj, ranked_all, ranked_pro,
            teachers_dir, teachers_org, kt_code, reserve, total_ze, discipline_dop, reserve_hrs, kt_appr_date,
            oop_load, holidays_w3, teachers_pro, base_part, year_load, military_load)
        VALUES({training_direct_id}, '{dir_reg_num}', now(), {code}, {p_mastering_m},
            {labour_intensity}, {dir_state}, '{Gen_GOS}', {hours_total}, {time_of_development}, {theoretical_training},
            {sessions_count}, {study_training}, {practical_training}, {state_sertification}, {holidays}, {kt_time},
            {teaching_load}, {auditorium_min}, {auditorium_max}, {vacation_time}, {vacation_time_w}, '{program_name}',
            '{EduForm}', '{description}', {p_mastering_w}, {by_competences}, '{specialization}', '{prefix_comp}',
            {f_education_profiles}, {doctors_all}, {doctors_pro}, {equal_all}, {ranked_adj}, {ranked_all}, {ranked_pro},
            {teachers_dir}, {teachers_org}, '{kt_code}', {reserve}, {total_ze}, {discipline_dop}, {reserve_hrs},
            {kt_appr_date},{oop_load}, {holidays_w3}, {teachers_pro}, {base_part}, {year_load}, {military_load})
        RETURNING *
           """ \
            .format(training_direct_id=data.get("training_direct_id"), dir_reg_num=data.get("dir_reg_num") or "null",
                    dir_reg_date=data.get("dir_reg_date"), code=data.get("code") or "null",
                    p_mastering_m=data.get("p_mastering_m") or "null",
                    labour_intensity=data.get("labour_intensity") or "null",
                    dir_state=data.get("dir_state") or "true", Gen_GOS=data.get("Gen_GOS"),
                    hours_total=data.get("hours_total") or "null",
                    time_of_development=data.get("time_of_development") or "null",
                    theoretical_training=data.get("theoretical_training") or "null",
                    sessions_count=data.get("sessions_count") or "null",
                    study_training=data.get("study_training") or "null",
                    practical_training=data.get("practical_training") or "null",
                    state_sertification=data.get("state_sertification") or "null",
                    holidays=data.get("holidays") or "null",
                    kt_time=data.get("kt_time") or "null", teaching_load=data.get("teaching_load") or "null",
                    auditorium_min=data.get("auditorium_min") or "null",
                    auditorium_max=data.get("auditorium_max") or "null",
                    vacation_time=data.get("vacation_time") or "null",
                    vacation_time_w=data.get("vacation_time_w") or "null",
                    program_name=data.get("program_name") or "null", EduForm=data.get("EduForm") or "null",
                    description=data.get("description") or "null", p_mastering_w=data.get("p_mastering_w") or "null",
                    by_competences=data.get("by_competences") or "null",
                    specialization=data.get("specialization") or "null",
                    prefix_comp=data.get("prefix_comp") or "null",
                    f_education_profiles=data.get("f_education_profiles") or "null",
                    doctors_all=data.get("doctors_all") or "null", doctors_pro=data.get("doctors_pro") or "null",
                    equal_all=data.get("equal_all") or "null", ranked_adj=data.get("ranked_adj") or "null",
                    ranked_all=data.get("ranked_all") or "null", ranked_pro=data.get("ranked_pro") or "null",
                    teachers_dir=data.get("teachers_dir") or "null", teachers_org=data.get("teachers_org") or "null",
                    kt_code=data.get("kt_code") or "null", reserve=data.get("reserve") or "null",
                    total_ze=data.get("total_ze") or "null", discipline_dop=data.get("discipline_dop") or "null",
                    reserve_hrs=data.get("reserve_hrs") or "null", kt_appr_date=data.get("kt_appr_date") or "null",
                    oop_load=data.get("oop_load") or "null", holidays_w3=data.get("holidays_w3") or "null",
                    teachers_pro=data.get("teachers_pro") or "null", base_part=data.get("base_part") or "null",
                    year_load=data.get("year_load") or "null", military_load=data.get("military_load") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_edu_dirs(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += """({training_direct_id}, '{dir_reg_num}', now(), {code}, {p_mastering_m},
            {labour_intensity}, {dir_state}, '{Gen_GOS}', {hours_total}, {time_of_development}, {theoretical_training},
            {sessions_count}, {study_training}, {practical_training}, {state_sertification}, {holidays}, {kt_time},
            {teaching_load}, {auditorium_min}, {auditorium_max}, {vacation_time}, {vacation_time_w}, '{program_name}',
            '{EduForm}', '{description}', {p_mastering_w}, {by_competences}, '{specialization}', '{prefix_comp}',
            {f_education_profiles}, {doctors_all}, {doctors_pro}, {equal_all}, {ranked_adj}, {ranked_all}, {ranked_pro},
            {teachers_dir}, {teachers_org}, '{kt_code}', {reserve}, {total_ze}, {discipline_dop}, {reserve_hrs},
            {kt_appr_date},{oop_load}, {holidays_w3}, {teachers_pro}, {base_part}, {year_load}, {military_load})""" \
                .format(training_direct_id=data.get("training_direct_id"),
                        dir_reg_num=data.get("dir_reg_num") or "null",
                        dir_reg_date=data.get("dir_reg_date"), code=data.get("code") or "null",
                        p_mastering_m=data.get("p_mastering_m") or "null",
                        labour_intensity=data.get("labour_intensity") or "null",
                        dir_state=data.get("dir_state") or "true", Gen_GOS=data.get("Gen_GOS"),
                        hours_total=data.get("hours_total") or "null",
                        time_of_development=data.get("time_of_development") or "null",
                        theoretical_training=data.get("theoretical_training") or "null",
                        sessions_count=data.get("sessions_count") or "null",
                        study_training=data.get("study_training") or "null",
                        practical_training=data.get("practical_training") or "null",
                        state_sertification=data.get("state_sertification") or "null",
                        holidays=data.get("holidays") or "null",
                        kt_time=data.get("kt_time") or "null", teaching_load=data.get("teaching_load") or "null",
                        auditorium_min=data.get("auditorium_min") or "null",
                        auditorium_max=data.get("auditorium_max") or "null",
                        vacation_time=data.get("vacation_time") or "null",
                        vacation_time_w=data.get("vacation_time_w") or "null",
                        program_name=data.get("program_name") or "null", EduForm=data.get("EduForm") or "null",
                        description=data.get("description") or "null",
                        p_mastering_w=data.get("p_mastering_w") or "null",
                        by_competences=data.get("by_competences") or "null",
                        specialization=data.get("specialization") or "null",
                        prefix_comp=data.get("prefix_comp") or "null",
                        f_education_profiles=data.get("f_education_profiles") or "null",
                        doctors_all=data.get("doctors_all") or "null", doctors_pro=data.get("doctors_pro") or "null",
                        equal_all=data.get("equal_all") or "null", ranked_adj=data.get("ranked_adj") or "null",
                        ranked_all=data.get("ranked_all") or "null", ranked_pro=data.get("ranked_pro") or "null",
                        teachers_dir=data.get("teachers_dir") or "null",
                        teachers_org=data.get("teachers_org") or "null",
                        kt_code=data.get("kt_code") or "null", reserve=data.get("reserve") or "null",
                        total_ze=data.get("total_ze") or "null", discipline_dop=data.get("discipline_dop") or "null",
                        reserve_hrs=data.get("reserve_hrs") or "null", kt_appr_date=data.get("kt_appr_date") or "null",
                        oop_load=data.get("oop_load") or "null", holidays_w3=data.get("holidays_w3") or "null",
                        teachers_pro=data.get("teachers_pro") or "null", base_part=data.get("base_part") or "null",
                        year_load=data.get("year_load") or "null", military_load=data.get("military_load") or "null")
            if data != data_list[-1]:
                values += ", "

        sql = """
            INSERT INTO edu_direction(training_direct_id, dir_reg_num, dir_reg_date, code, p_mastering_m,
                labour_intensity, dir_state, "Gen_GOS", hours_total, time_of_development, theoretical_training,
                sessions_count, study_training, practical_training, state_sertification, holidays, kt_time,
                teaching_load, auditorium_min, auditorium_max, vacation_time, vacation_time_w, program_name,
                "EduForm", description, p_mastering_w, by_competences, specialization, prefix_comp,
                f_education_profiles, doctors_all, doctors_pro, equal_all, ranked_adj, ranked_all, ranked_pro,
                teachers_dir, teachers_org, kt_code, reserve, total_ze, discipline_dop, reserve_hrs, kt_appr_date,
                oop_load, holidays_w3, teachers_pro, base_part, year_load, military_load)
            VALUES {values} RETURNING *
                """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_education_dir(lname: str, edu_dir_id: int) -> Union[bool, dict]:
        sql = """
                SELECT edu_direct_id, training_direct_id, dir_reg_num, dir_reg_date, code, p_mastering_m,
                    labour_intensity::float, dir_state, "Gen_GOS", hours_total, time_of_development::float,
                    theoretical_training::float, sessions_count::float, study_training::float,
                    practical_training::float, state_sertification::float, holidays::float, kt_time,
                    teaching_load, auditorium_min, auditorium_max, vacation_time::float, vacation_time_w::float,
                    program_name, "EduForm", description, p_mastering_w, by_competences, specialization, prefix_comp,
                    f_education_profiles, doctors_all::float, doctors_pro::float, equal_all::float, ranked_adj::float,
                    ranked_all::float, ranked_pro::float, teachers_dir::float, teachers_org::float,
                    kt_code, reserve, total_ze, discipline_dop, reserve_hrs, kt_appr_date,
                    oop_load, holidays_w3, teachers_pro, base_part::float, year_load::float, military_load::float  
                FROM edu_direction
                WHERE edu_direct_id={edu_dir_id}""".format(edu_dir_id=edu_dir_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_many_education_dirs(lname: str) -> Union[bool, list]:
        sql = """SELECT edu_direct_id, training_direct_id, dir_reg_num, dir_reg_date, code, p_mastering_m,
            labour_intensity::float, dir_state, "Gen_GOS", hours_total, time_of_development::float,
            theoretical_training::float, sessions_count::float, study_training::float,
            practical_training::float, state_sertification::float, holidays::float, kt_time,
            teaching_load, auditorium_min, auditorium_max, vacation_time::float, vacation_time_w::float, program_name,
            "EduForm", description, p_mastering_w, by_competences, specialization, prefix_comp,
            f_education_profiles, doctors_all::float, doctors_pro::float, equal_all::float, ranked_adj::float,
            ranked_all::float, ranked_pro::float, teachers_dir::float, teachers_org::float,
            kt_code, reserve, total_ze, discipline_dop, reserve_hrs, kt_appr_date,
            oop_load, holidays_w3, teachers_pro, base_part::float, year_load::float, military_load::float 
            FROM edu_direction ORDER BY edu_direct_id"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_education_dir(lname: str, edu_dir_id: int, data: list) -> Union[bool, dict]:
        sql = """
            UPDATE edu_direction SET training_direct_id={training_direct_id}, dir_reg_num='{dir_reg_num}', code={code}, 
                p_mastering_m={p_mastering_m}, labour_intensity={labour_intensity}, dir_state={dir_state},
                "Gen_GOS"='{Gen_GOS}', hours_total={hours_total}, time_of_development={time_of_development},
                theoretical_training={theoretical_training}, sessions_count={sessions_count},
                study_training={study_training}, practical_training={practical_training}, 
                state_sertification={state_sertification}, holidays={holidays}, kt_time={kt_time},
                teaching_load={teaching_load}, auditorium_min={auditorium_min}, auditorium_max={auditorium_max}, 
                vacation_time={vacation_time}, vacation_time_w={vacation_time_w}, program_name='{program_name}',
                "EduForm"='{EduForm}', description='{description}', p_mastering_w={p_mastering_w},
                by_competences={by_competences}, specialization='{specialization}', prefix_comp='{prefix_comp}',
                f_education_profiles={f_education_profiles}, doctors_all={doctors_all}, doctors_pro={doctors_pro},
                equal_all={equal_all}, ranked_adj={ranked_adj}, ranked_all={ranked_all}, ranked_pro={ranked_pro},
                teachers_dir={teachers_dir}, teachers_org={teachers_org}, kt_code='{kt_code}', reserve={reserve},
                total_ze={total_ze}, discipline_dop={discipline_dop}, reserve_hrs={reserve_hrs},
                kt_appr_date={kt_appr_date}, oop_load={oop_load}, holidays_w3={holidays_w3}, 
                teachers_pro={teachers_pro}, base_part={base_part}, year_load={year_load}, military_load={military_load}
            WHERE edu_direct_id={edu_direct_id} RETURNING *""" \
            .format(training_direct_id=data.get("training_direct_id"),
                    dir_reg_num=data.get("dir_reg_num") or "null",
                    dir_reg_date=data.get("dir_reg_date"), code=data.get("code") or "null",
                    p_mastering_m=data.get("p_mastering_m") or "null",
                    labour_intensity=data.get("labour_intensity") or "null",
                    dir_state=data.get("dir_state") or "true", Gen_GOS=data.get("Gen_GOS"),
                    hours_total=data.get("hours_total") or "null",
                    time_of_development=data.get("time_of_development") or "null",
                    theoretical_training=data.get("theoretical_training") or "null",
                    sessions_count=data.get("sessions_count") or "null",
                    study_training=data.get("study_training") or "null",
                    practical_training=data.get("practical_training") or "null",
                    state_sertification=data.get("state_sertification") or "null",
                    holidays=data.get("holidays") or "null",
                    kt_time=data.get("kt_time") or "null", teaching_load=data.get("teaching_load") or "null",
                    auditorium_min=data.get("auditorium_min") or "null",
                    auditorium_max=data.get("auditorium_max") or "null",
                    vacation_time=data.get("vacation_time") or "null",
                    vacation_time_w=data.get("vacation_time_w") or "null",
                    program_name=data.get("program_name") or "null", EduForm=data.get("EduForm") or "null",
                    description=data.get("description") or "null",
                    p_mastering_w=data.get("p_mastering_w") or "null",
                    by_competences=data.get("by_competences") or "null",
                    specialization=data.get("specialization") or "null",
                    prefix_comp=data.get("prefix_comp") or "null",
                    f_education_profiles=data.get("f_education_profiles") or "null",
                    doctors_all=data.get("doctors_all") or "null", doctors_pro=data.get("doctors_pro") or "null",
                    equal_all=data.get("equal_all") or "null", ranked_adj=data.get("ranked_adj") or "null",
                    ranked_all=data.get("ranked_all") or "null", ranked_pro=data.get("ranked_pro") or "null",
                    teachers_dir=data.get("teachers_dir") or "null",
                    teachers_org=data.get("teachers_org") or "null",
                    kt_code=data.get("kt_code") or "null", reserve=data.get("reserve") or "null",
                    total_ze=data.get("total_ze") or "null", discipline_dop=data.get("discipline_dop") or "null",
                    reserve_hrs=data.get("reserve_hrs") or "null", kt_appr_date=data.get("kt_appr_date") or "null",
                    oop_load=data.get("oop_load") or "null", holidays_w3=data.get("holidays_w3") or "null",
                    teachers_pro=data.get("teachers_pro") or "null", base_part=data.get("base_part") or "null",
                    year_load=data.get("year_load") or "null", military_load=data.get("military_load") or "null",
                    edu_direct_id=edu_dir_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        res = dict(res)
        for key, value in res.items():
            if isinstance(value, decimal.Decimal):
                res[key] = float(value)
        return res


class MilitaryProfession:

    @staticmethod
    def create_mp(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
                INSERT INTO militaryprofession(qualification, name, shortname, purposegraduates, edu_direct_id,
                    specialization, code, ed_specialization)
                VALUES({qualification}, '{name}', '{shortname}', '{purposegraduates}', {edu_direct_id},
                    '{specialization}', {code}, '{ed_specialization}') RETURNING *
                """.format(qualification=data.get("qualification"), name=data.get("name"),
                           shortname=data.get("shortname"), purposegraduates=data.get("purposegraduates"),
                           edu_direct_id=data.get("edu_direct_id") or "null",
                           specialization=data.get("specialization") or "null", code=data.get("code") or "null",
                           ed_specialization=data.get("ed_specialization") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_mp(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += """({qualification}, '{name}', '{shortname}', '{purposegraduates}', {edu_direct_id},
                    '{specialization}', {code}, '{ed_specialization}')""" \
                .format(qualification=data.get("qualification"), name=data.get("name"),
                        shortname=data.get("shortname"), purposegraduates=data.get("purposegraduates"),
                        edu_direct_id=data.get("edu_direct_id") or "null",
                        specialization=data.get("specialization") or "null", code=data.get("code") or "null",
                        ed_specialization=data.get("ed_specialization") or "null")
            if data != data_list[-1]:
                values += ", "

        sql = """
                INSERT INTO militaryprofession(qualification, name, shortname, purposegraduates, edu_direct_id,
                    specialization, code, ed_specialization)
                VALUES {values} RETURNING *
            """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_mp(lname: str, mpid: int) -> Union[bool, dict]:
        sql = """
                       SELECT * FROM militaryprofession
                       WHERE mpid={mpid}""".format(mpid=mpid)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_many_mps(lname: str) -> Union[bool, list]:
        sql = """SELECT * FROM militaryprofession ORDER BY mpid"""
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_mp(lname: str, mpid: int, data: list) -> Union[bool, dict]:
        sql = """
                UPDATE militaryprofession SET qualification={qualification}, name='{name}', shortname='{shortname}', 
                    purposegraduates='{purposegraduates}', edu_direct_id={edu_direct_id},
                    specialization='{specialization}', code={code}, ed_specialization='{ed_specialization}'
                WHERE mpid={mpid} RETURNING *""" \
            .format(qualification=data.get("qualification"), name=data.get("name"),
                    shortname=data.get("shortname"), purposegraduates=data.get("purposegraduates"),
                    edu_direct_id=data.get("edu_direct_id") or "null",
                    specialization=data.get("specialization") or "null", code=data.get("code") or "null",
                    ed_specialization=data.get("ed_specialization") or "null", mpid=mpid
                    )
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)
