# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Gradebook:

    def __init__(self,cname):
        self.lname = cname
   
    def getGradebook(self,uid,semesterid):

        conn = current_app.ms.db(self.lname).connect()
        
        sql = """SELECT xp_fill_report_gradebook(:uid, :semesterid);
select distinct *,to_char(certdate,'DD.MM.YYYY') as certdate_txt  FROM tmpgradebook
ORDER BY kurs, termNum,certdate;"""


        stmt = text(sql)
        stmt = stmt.bindparams(uid=uid)    
        stmt = stmt.bindparams(semesterid=semesterid)    
        query = conn.execute(stmt)

        gradeBook = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        gb= {}

        for f in gradeBook:
            gb[f['yearname']] = {}

        for f in gradeBook:
            gb[f['yearname']][f['termnum']] = []

        for f in gradeBook:
            gb[f['yearname']][f['termnum']].append(f)


        return gb