from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app


class LessonPlans:
    def __init__(self, cname):
        self.lname = cname

    def getLessonPlansSubjet(
        self,
        school_year,
        idfaculty,
        idcurriculum,
        cid,
        meta_course,
        eyid,
        tlid,
        paginateFrom,
        maxResults,
    ):
        conn = current_app.ms.db(self.lname).connect()

        select_count = """SELECT COUNT(*) as row_count FROM ("""

        sql = """ SELECT tab.id_curriculum_course, tab.tlid, clm.cname as cname, 
            ey."number" as kurs,tl."number" as semester, concat_ws('',crs.course_index, crs.title) as predmet, 
        SUM( 
            ifnull(ccd.lecturing,0)+ 
            ifnull(ccd.seminar,0)+ 
            ifnull(ccd.laboratory_works,0)+ 
            ifnull(ccd.practical_training,0)+ 
            ifnull(ccd.group_exercises,0)+ 
            ifnull(ccd.group_classes,0)+ 
            ifnull(ccd.tactical_exercises,0)+ 
            ifnull(ccd.war_games,0)+ 
            ifnull(ccd.course_work,0)+ 
            ifnull(ccd.ind_with_lecturer,0)+ 
            ifnull(ccd.test,0)+ 
            ifnull(ccd.independent_work,0)+ 
            ifnull(ccd.control_work,0) 
            ) as hours 
        FROM 
        (SELECT  cc.id_curriculum_course, tl.tlid 
        FROM curriculum clm 
           JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
            JOIN militaryprofession mp ON mp.mpid=q.mpid 
             JOIN groupname g ON g.f_militaryprofession=mp.mpid 
              JOIN group_history gh ON gh.gid=g.gid  
             JOIN cathedras cs ON cs.idcathedra=g.idcathedra 
              JOIN faculty f ON f.idfaculty=coalesce(g.idfaculty,cs.faculty)  
             JOIN curriculum_detail cd ON cd.idcurriculum=clm.idcurriculum 
              JOIN curriculum_course cc ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
              JOIN study_by_terms sbt ON sbt.id_curr_detail=cd.id_curr_detail and sbt.cathedra is null AND sbt.trim_time>0 
               JOIN educationyears ey ON ey.eyid=sbt.eyid AND ey."number"=gh.year  
               JOIN termslist tl ON tl.tlid=sbt.tlid AND tl.eyid=ey.eyid  
        WHERE 1=1
                 """

        if school_year != 0:
            sql += " AND gh.school_year=:school_year "
        if idfaculty != 0:
            sql += " AND (f.idfaculty=:idfaculty OR f.idfaculty=0) "
        if idcurriculum != 0:
            sql += " AND (clm.idcurriculum=:idcurriculum OR clm.idcurriculum=0) "
        if eyid != 0:
            sql += " AND (ey.eyid=:eyid OR ey.eyid=0) "
        if tlid != 0:
            sql += " AND (tl.tlid=:tlid OR tl.tlid=0) "
        if cid != 0 or meta_course != 0:
            sql += """ GROUP BY cc.id_curriculum_course, tl.tlid  
            ) tab 
             JOIN curriculum_course_details ccd ON ccd.id_curriculum_course=tab.id_curriculum_course AND ccd.tlid=tab.tlid 
             JOIN termslist tl ON tl.tlid=tab.tlid 
             JOIN educationyears ey ON ey.eyid= tl.eyid 
             JOIN curriculum_course cc ON cc.id_curriculum_course=tab.id_curriculum_course 
             JOIN curriculum_detail cd ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
             JOIN courses crs ON crs.cid=cd.cid   
             JOIN curriculum clm ON clm.idcurriculum=cd.idcurriculum 
            WHERE 1=1
            """
            if cid != 0:
                sql += " AND (crs.cid=:cid OR crs.cid=0) "
            if meta_course != 0:
                sql += " AND (crs.meta_course=:meta_course OR crs.meta_course=0) "

            sql += """GROUP BY tab.id_curriculum_course, tab.tlid, clm.cname,ey."number",tl."number", crs.title,crs.course_index 
            ORDER BY tab.id_curriculum_course, tab.tlid, clm.cname,ey."number",tl."number", crs.course_index, crs.title"""
        else:
            sql += """GROUP BY cc.id_curriculum_course, tl.tlid  
            ) tab 
             JOIN curriculum_course_details ccd ON ccd.id_curriculum_course=tab.id_curriculum_course AND ccd.tlid=tab.tlid 
             JOIN termslist tl ON tl.tlid=tab.tlid 
             JOIN educationyears ey ON ey.eyid= tl.eyid 
             JOIN curriculum_course cc ON cc.id_curriculum_course=tab.id_curriculum_course 
             JOIN curriculum_detail cd ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
             JOIN courses crs ON crs.cid=cd.cid   
             JOIN curriculum clm ON clm.idcurriculum=cd.idcurriculum 
            GROUP BY tab.id_curriculum_course, tab.tlid, clm.cname,ey."number",tl."number", crs.title,crs.course_index 
            ORDER BY tab.id_curriculum_course, tab.tlid, clm.cname,ey."number",tl."number", crs.course_index, crs.title
            """

        sql_count = select_count + sql + """) as sub_query;"""

        # Пагинация
        if paginateFrom is not None and maxResults is not None:
            sql += " LIMIT :maxResults" + " OFFSET :paginateFrom"
        elif maxResults is not None:
            sql += " LIMIT :maxResults"

        stmt = text(sql)
        stmt_count = text(sql_count)

        params = {
            "school_year": school_year,
            "idfaculty": idfaculty,
            "idcurriculum": idcurriculum,
            "eyid": eyid,
            "tlid": tlid,
            "cid": cid,
            "meta_course": meta_course,
        }
        for key, value in params.items():
            if value != 0:
                stmt = stmt.bindparams(**{key: value})
                stmt_count = stmt_count.bindparams(**{key: value})

        if paginateFrom is not None and maxResults is not None:
            stmt = stmt.bindparams(paginateFrom=paginateFrom)
            stmt = stmt.bindparams(maxResults=maxResults)
        elif maxResults is not None:
            stmt = stmt.bindparams(maxResults=maxResults)

        query = conn.execute(stmt_count)
        count = query.scalar()
        query = conn.execute(stmt)

        lesson_plans = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return {"count": count, "lesson_plans": lesson_plans}
