# LMSAPI/API/Term.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle


class Term:
    def __init__(self, cname):
        self.lname = cname

    def getListFromRedis(self):
        cachedClist = current_app.ms.redis(self.lname).get("SYSTERMLIST")
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setListToRedis(self, ylist):
        current_app.ms.redis(self.lname).setex("SYSTERMLIST", 5, pickle.dumps(ylist))
        return

    def get_term_list(self, date):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text(
            """
                WITH current_term AS (
                    SELECT *
					FROM terms
					WHERE TO_DATE(term_begin, 'DD.MM.YYYY') <= DATE :date
					ORDER BY
						-- приоритет: сначала диапазоны, куда попадает дата (0), потом предыдущие (1)
						CASE
							WHEN TO_DATE(term_end, 'DD.MM.YYYY') >= DATE :date THEN 0
							ELSE 1
						END ASC,
						-- внутри группы сортируем:
						-- для подходящих — по возрастанию конца периода,
						-- для предыдущих — по убыванию конца периода
						CASE
							WHEN TO_DATE(term_end, 'DD.MM.YYYY') >= DATE :date
							THEN TO_DATE(term_end, 'DD.MM.YYYY')
							ELSE NULL
						END ASC,
						CASE
							WHEN TO_DATE(term_end, 'DD.MM.YYYY') < DATE :date
							THEN TO_DATE(term_end, 'DD.MM.YYYY')
							ELSE NULL
						END DESC
					LIMIT 1
                ),
                previous_term AS (
                    SELECT *
                    FROM terms
                    WHERE TO_DATE(term_end, 'DD.MM.YYYY') < TO_DATE((SELECT term_begin FROM current_term), 'DD.MM.YYYY')
                    ORDER BY TO_DATE(term_end, 'DD.MM.YYYY') DESC
                    LIMIT 1
                )
                SELECT *
                FROM (
                    SELECT * FROM current_term
                    UNION ALL
                    SELECT * FROM previous_term
                ) terms_combined
                ORDER BY TO_DATE(term_end, 'DD.MM.YYYY') ASC;
            """
        )
        stmt = stmt.bindparams(date=date)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getTermList(self, id):
        termList = self.getListFromRedis()

        if termList is not None:
            return termList

        conn = current_app.ms.db(self.lname).connect()

        stmt = text("select * from terms where year = :id")
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        termList = {"terms": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        self.setListToRedis(termList)

        return termList

    def getTerm(self, termid):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text("select * from terms where trmid = :id")
        stmt = stmt.bindparams(id=termid)
        query = conn.execute(stmt)

        term = {"term": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return term

    def get_term(lname, trmid):
        conn = current_app.ms.db(lname).connect()
        stmt = text("select * from terms where trmid = :id")
        stmt = stmt.bindparams(id=trmid)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getTermsList(self, id):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text(
            "select * from termslist where eyid = :id or 0 = :id order by sorting"
        )
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        termList = {"terms": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        self.setListToRedis(termList)

        return termList

    def getTermByYearFacultyCurriculumKurs(
        self, school_year, idfaculty, idcurriculum, eyid
    ):
        conn = current_app.ms.db(self.lname).connect()

        sql = """ SELECT distinct tl.tlid, tl.name, tl.number
        FROM 
        (SELECT  cc.id_curriculum_course, tl.tlid 
        FROM curriculum clm 
           JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
            JOIN militaryprofession mp ON mp.mpid=q.mpid 
             JOIN groupname g ON g.f_militaryprofession=mp.mpid 
              JOIN group_history gh ON gh.gid=g.gid 
             JOIN cathedras cs ON cs.idcathedra=g.idcathedra 
              JOIN faculty f ON f.idfaculty=coalesce(g.idfaculty,cs.faculty)
             JOIN curriculum_detail cd ON cd.idcurriculum=clm.idcurriculum 
              JOIN curriculum_course cc ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
              JOIN study_by_terms sbt ON sbt.id_curr_detail=cd.id_curr_detail and sbt.cathedra is null AND sbt.trim_time>0 
               JOIN educationyears ey ON ey.eyid=sbt.eyid AND ey."number"=gh.year
               JOIN termslist tl ON tl.tlid=sbt.tlid AND tl.eyid=ey.eyid 
        WHERE 1=1
         """

        if school_year != 0:
            sql = sql + " AND gh.school_year=:school_year "
        if idfaculty != 0:
            sql = sql + " AND (f.idfaculty=:idfaculty OR f.idfaculty=0) "
        if idcurriculum != 0:
            sql = sql + " AND (clm.idcurriculum=:idcurriculum OR clm.idcurriculum=0) "
        if eyid != 0:
            sql += " AND (ey.eyid=:eyid OR ey.eyid=0) "

        sql = (
            sql
            + """GROUP BY cc.id_curriculum_course, tl.tlid  
            ) tab 
             JOIN curriculum_course_details ccd ON ccd.id_curriculum_course=tab.id_curriculum_course AND ccd.tlid=tab.tlid 
             JOIN termslist tl ON tl.tlid=tab.tlid 
             JOIN educationyears ey ON ey.eyid= tl.eyid 
             JOIN curriculum_course cc ON cc.id_curriculum_course=tab.id_curriculum_course 
             JOIN curriculum_detail cd ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
             JOIN courses crs ON crs.cid=cd.cid
             JOIN curriculum clm ON clm.idcurriculum=cd.idcurriculum   
            ORDER BY tl.name ASC;
            """
        )

        if school_year == 0 and idfaculty == 0 and idcurriculum == 0 and eyid == 0:
            sql = "SELECT tlid, name, number FROM termslist"

        stmt = text(sql)

        if school_year != 0:
            stmt = stmt.bindparams(school_year=school_year)
        if idfaculty != 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if eyid != 0:
            stmt = stmt.bindparams(eyid=eyid)
        query = conn.execute(stmt)

        term = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return term
