# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Week:

    def __init__(self,cname):
        self.lname = cname
   
    def getListFromRedis(self):
        cachedClist = current_app.ms.redis(self.lname).get("WEEKLIST")
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setListToRedis(self,ylist):
        current_app.ms.redis(self.lname).setex("WEEKLIST",500,pickle.dumps(ylist))
        return

    def getWeekList(self,studyyear):

      
        weekList = self.getListFromRedis()
        
        if weekList is not None:
            return weekList

        conn = current_app.ms.db(self.lname).connect()
        
        stmt = text("""select w.week_id,
       w.week_name,  date_format(w.wstart_date, '%d.%m.%Y') week_start ,
                                        date_format(w.wend_date, '%d.%m.%Y') week_end
      from nnz_weeks w
      where exists (select 1
                    from term_weeks tw 
                    inner join terms t on (tw.trmid = t.trmid and t.year = :studyyear )             
      where tw.week_id = w.week_id)
      order by w.wstart_date;""")
        stmt = stmt.bindparams(studyyear=studyyear)  
        query = conn.execute(stmt)

        weekList = {'weekList': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

        self.setListToRedis(weekList)

        return weekList