from flask import Blueprint, g, request, jsonify
from flask_cors import CORS

from LMSAPI.api.Models.CombatTrainingTasks import CombatTrainingTasks
from LMSAPI.api.Models.File import File

combat_training_tasks_api = Blueprint('combat_training_tasks_api', __name__)

CORS(combat_training_tasks_api)


@combat_training_tasks_api.route('/lms/api/v1.0/<string:lname>/combat_training_tasks', methods=['GET'])
def get_combat_training_tasks(lname: str):
    """GET combat training tasks

    Args:
        lname (str): database name
    
    Returns:
        json: combat training tasks
    """
    limit = request.args.get("limit")
    offset = request.args.get("offset")
    count = request.args.get("count")
    result = CombatTrainingTasks.get_combat_training_tasks(lname=lname, limit=limit, offset=offset, count=count)
    return jsonify(result), 200


@combat_training_tasks_api.route(
    '/lms/api/v1.0/<string:lname>/combat_training_tasks/<int:post_id>/image/<string:image_name>', 
    methods=['GET']
)
def get_combat_training_task_image(lname: str, post_id: int, image_name: str):
    """GET combat training task image

    Args:
        lname (str): database name
        post_id (int): combat training task id
        image_name (str): image name
    
    Returns:
        image: combat training task image
    """
    file_path = CombatTrainingTasks.get_combat_training_task_image_path(lname=lname, post_id=post_id)
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=file_path,
        file_name=image_name,
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )