from flask import Flask, jsonify, request, current_app
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Curriculum import Curriculum
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

curriculum_api = Blueprint("curriculum_api", __name__)

CORS(curriculum_api)


# Get all  curriculums
@curriculum_api.route("/lms/api/v1.0/<lname>/curriculum", methods=["GET"])
@auth.login_required
def getAllCurriculums(lname):
    result = Curriculum(lname).getAllCurriculums()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


# Get  curriculums
@curriculum_api.route(
    "/lms/api/v1.0/<lname>/curriculum/<int:syid>/<int:mpid>", methods=["GET"]
)
@auth.login_required
# @user_permission_modes("Справочники", "Учебный план", ["Нет"])
def getCurriculum(lname, syid, mpid):
    """GET with ID of Cathedra to get list of groups"""
    result = Curriculum(lname).getCurriculum(syid, mpid)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@curriculum_api.route(
    "/lms/api/v1.0/<lname>/curriculum/<int:syid>/<int:mpid>/<int:idfaculty>",
    methods=["GET"],
)
@auth.login_required
def getCurriculumByFaculty(lname, syid, mpid, idfaculty):
    """GET with ID of Cathedra to get list of groups"""
    result = Curriculum(lname).getCurriculumByFaculty(syid, mpid, idfaculty)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@curriculum_api.route(
    "/lms/api/v1.0/<lname>/lesson_plans/curriculum/<int:syid>/<int:idfaculty>",
    methods=["GET"],
)
@auth.login_required
def getLessonPlansCurriculumByYearFaculty(lname, syid, idfaculty):
    """GET with ID of Cathedra to get list of groups"""
    result = Curriculum(lname).getLessonPlansCurriculumByYearFaculty(syid, idfaculty)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@curriculum_api.route(
    "/lms/api/v1.0/<lname>/curriculum/cathedra/<int:idcathedra>/<int:idmetacourse>",
    methods=["GET"],
)
@auth.login_required
def getCurriculumByMetacourseCathedra(lname, idcathedra, idmetacourse):
    """GET with ID of Cathedra to get list of groups"""
    result = Curriculum(lname).getCurriculumByMetacourseCathedra(
        idcathedra, idmetacourse
    )

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


# Get  curriculum by id
@curriculum_api.route("/lms/api/v1.0/<lname>/curriculum/<int:id>", methods=["GET"])
@auth.login_required
def getGroup(lname, id):
    result = Curriculum(lname).getCurriculumid(id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@curriculum_api.route(
    "/lms/api/v1.0/<lname>/curriculum_by_cathedra/<int:cathedra_id>", methods=["GET"]
)
@auth.login_required
def get_curriculum_by_cathedra(lname, cathedra_id: int) -> list:
    result = Curriculum(lname).get_curriculum_by_cathedra(cathedra_id)

    if result is None:
        return jsonify([])

    return jsonify(result)


@curriculum_api.route(
    "/lms/api/v1.0/<lname>/curriculum/complex_thematic_planning/<int:idfaculty>",
    methods=["GET"],
)
@auth.login_required
def get_curriculum_for_complex_thematic_planning(lname, idfaculty: int) -> list:
    result = Curriculum(lname).get_curriculum_for_complex_thematic_planning(idfaculty)

    if result is None:
        return jsonify([])

    return jsonify(result)
