from typing import Union, Tuple, Any

from flask import jsonify, request, json
from flask import Blueprint
from LMSAPI.api.Models.Disciplines import Disciplines
from flask_cors import CORS

disciplines_api = Blueprint('disciplines_api', __name__)

CORS(disciplines_api)


# FOR DISCIPLINE BLOCKS

@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_block', methods=['POST'])
# @auth.login_required
def create_discipline_block(lname: str) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).create_block(lname, data)
    if not res:
        return jsonify(success=False), 404
    res = {**res, **data}
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_many_blocks', methods=['POST'])
# @auth.login_required
def create_disciplines_many_blocks(lname: str) -> Union[Tuple[Any, int], list]:
    data_list = json.loads(request.data)
    res = Disciplines(lname).create_many_blocks(lname, data_list)
    if not res:
        return jsonify(success=False), 404
    for i, item in enumerate(res):
        res[i] = ({**item, **data_list[i]})
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_block/<int:block_id>', methods=['GET'])
# @auth.login_required
def get_discipline_block(lname: str, block_id: int) -> Union[Tuple[Any, int], dict]:
    res = Disciplines(lname).get_discipline_block(lname, block_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/get_disciplines_many_blocks', methods=['GET'])
# @auth.login_required
def get_disciplines_many_blocks(lname: str) -> Union[Tuple[Any, int], list]:
    res = Disciplines(lname).get_disciplines_many_blocks(lname)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/update_discipline_block/<int:block_id>', methods=['PUT'])
# @auth.login_required
def update_discipline_block(lname: str, block_id: int) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).update_discipline_block(lname, block_id, data)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


# FOR DISCIPLINE CYCLES


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_cycle', methods=['POST'])
# @auth.login_required
def create_discipline_cycle(lname: str) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).create_cycle(lname, data)
    if not res:
        return jsonify(success=False), 404
    res = {**res, **data}
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_many_cycles', methods=['POST'])
# @auth.login_required
def create_disciplines_many_cycles(lname: str) -> Union[Tuple[Any, int], list]:
    data_list = json.loads(request.data)
    res = Disciplines(lname).create_many_cycles(lname, data_list)
    if not res:
        return jsonify(success=False), 404
    for i, item in enumerate(res):
        res[i] = ({**item, **data_list[i]})
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_cycle/<int:cycle_id>', methods=['GET'])
# @auth.login_required
def get_discipline_cycle(lname: str, cycle_id: int) -> Union[Tuple[Any, int], dict]:
    res = Disciplines(lname).get_discipline_cycle(lname, cycle_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/get_disciplines_many_cycles', methods=['GET'])
# @auth.login_required
def get_disciplines_many_cycles(lname: str) -> Union[Tuple[Any, int], list]:
    res = Disciplines(lname).get_disciplines_many_cycles(lname)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/update_discipline_cycle/<int:cycle_id>', methods=['PUT'])
# @auth.login_required
def update_discipline_cycle(lname: str, cycle_id: int) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).update_discipline_cycle(lname, cycle_id, data)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


# FOR DISCIPLINE GROUPS


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_group', methods=['POST'])
# @auth.login_required
def create_discipline_group(lname: str) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).create_group(lname, data)
    if not res:
        return jsonify(success=False), 404
    res = {**res, **data}
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_many_groups', methods=['POST'])
# @auth.login_required
def create_disciplines_many_groups(lname: str) -> Union[Tuple[Any, int], list]:
    data_list = json.loads(request.data)
    res = Disciplines(lname).create_many_groups(lname, data_list)
    if not res:
        return jsonify(success=False), 404
    for i, item in enumerate(res):
        res[i] = ({**item, **data_list[i]})
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/disciplines_group/<int:group_id>', methods=['GET'])
# @auth.login_required
def get_discipline_group(lname: str, group_id: int) -> Union[Tuple[Any, int], dict]:
    res = Disciplines(lname).get_discipline_group(lname, group_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/get_disciplines_many_groups', methods=['GET'])
# @auth.login_required
def get_disciplines_many_groups(lname: str) -> Union[Tuple[Any, int], list]:
    res = Disciplines(lname).get_disciplines_many_groups(lname)
    if not res:
        return jsonify(success=False), 400
    return jsonify(res)


@disciplines_api.route('/lms/api/v1.0/<lname>/update_discipline_group/<int:group_id>', methods=['PUT'])
# @auth.login_required
def update_discipline_group(lname: str, group_id: int) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = Disciplines(lname).update_discipline_group(lname, group_id, data)
    if not res:
        return jsonify(success=False), 400
    return jsonify(res)
