from flask import Flask,jsonify, request, current_app
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Progress     import Progress
from LMSAPI.api.Models.Group import Group
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

progress_api = Blueprint('progress_api', __name__)

CORS(progress_api)

@progress_api.route('/lms/api/v1.0/<lname>/progress/<int:uid>/<int:yearid>', methods=['GET'])
@auth.login_required
def getProgress(lname,uid,yearid):
    """Get Gradebook results"""
    g = Progress(lname)

    r = g.getProgress(uid,yearid)

    return jsonify(r)

@progress_api.route('/lms/api/v1.0/<lname>/progress_total/<int:uid>/<int:yearid>', methods=['GET'])
@auth.login_required
def getTotalProgress(lname,uid,yearid):
    """Get Gradebook results"""
    g = Progress(lname)

    r = g.getTotalProgress(uid,yearid)

    return jsonify(r)

@progress_api.route('/lms/api/v1.0/<lname>/progress_detail/<int:uid>/<int:semesterid>/<int:courseid>', methods=['GET'])
@auth.login_required
def getProgressDetail(lname,uid,semesterid,courseid):
    """Get Gradebook results"""
    g = Progress(lname)

    r = g.getProgressDetail(uid,semesterid,courseid)

    return jsonify(r)

