import json

from flask import Flask,jsonify, request, current_app, g, send_from_directory
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Room import Room
from flask_cors import CORS

room_api = Blueprint('room_api', __name__)

CORS(room_api)

@room_api.route('/lms/api/v1.0/<lname>/room', methods=['GET'])
def getRoomList(lname):
    """GET to generate a list of endpoints and their docstrings"""
    roomList = Room(lname).getRoomList(lname)
    
    return jsonify([fa.serialize() for fa in roomList]),200,{'Content-Type': 'text/json; charset=utf-8'}

@room_api.route('/lms/api/v1.0/<lname>/room/<int:id>', methods=['GET'])
def getRoom(lname,id):
    """GET to generate a list of endpoints and their docstrings"""
    result = Room(lname).getRoom(lname,id)

    if result is None:
        return jsonify(success=False),404

    return json.dumps(result, default=str)


@room_api.route('/lms/api/v1.0/<lname>/room/date/<string:date>', methods=['GET'])
# @auth.login_required
def room_by_date(lname,date):
    """GET to generate a list of endpoints and their docstrings"""

    tfoid = request.args.get('tfoid')
    result = Room(lname).getRoomByDate(lname, date, tfoid)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result=result), 200


@room_api.route('/lms/api/v1.0/<lname>/room/<int:rid>/files', methods=['GET'])
# @auth.login_required
def getRoomPhotosAndPanoramas(lname,rid):
    """GET to generate a list of endpoints and their docstrings"""
    result = Room(lname).getRoomPhotoAndPanorama(lname,rid)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result=result), 200


@room_api.route('/lms/api/v1.0/<lname>/room/<int:rid>/<string:file_type>/<string:file_name>', methods=['GET'])
# @auth.login_required
def getRoomFile(lname,rid,file_type,file_name):
    """GET to generate a list of endpoints and their docstrings"""
    result = Room(lname).getRoomPhotoOrPanorama(rid,file_type)

    if result is None:
        return jsonify(success=False),404
    
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=result,
        file_name='picture.png',
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )
