from flask import Flask,jsonify, request,current_app
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from flask import Blueprint,g
from flask_httpauth import HTTPBasicAuth
from LMSAPI.api.Models.User import User
from flask_cors import CORS
import sys,datetime,json
from datetime import timedelta
from LMSAPI.api.Models.Multiserver import Multiserver
from apiurls import APIURL

#https://blog.miguelgrinberg.com/post/restful-authentication-with-flask

auth = HTTPBasicAuth()

token_api = Blueprint('token_api', __name__)

CORS(token_api)

@auth.verify_password
def verify_password(username_or_token, password, rfid = None):
    """Verify user is correct"""
    # first try to authenticate by token
    try:
        fo = request.path.split('/')
        lname = fo[4]
        if rfid != None:
            u = User(lname)
            g.user = u.get_user_from_sql_rfid(rfid)
            if g.user != None:
                g.user.isTeacher = u.user_is_teachermid(g.user.mid)
                g.user.isJournalAdmin = u.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
                g.user.access_modes = u.allowed_modes(lname, g.user.mid)
                return True
            return False

        header = request.headers.get('x-library-apikey')
        if header != None:
            a = current_app.ms.librarykey(header)            
            if a != lname:
                return False
            userid = request.headers.get('x-library-apiuserid')            
            if userid == None:
                return False
            if userid == "-1":
                return True
            u = User(lname)
            
            g.user = u.get_user_from_sql_id(userid)            
            if g.user != None:
                g.user.isTeacher = u.user_is_teachermid(userid)
                g.user.isJournalAdmin = u.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
                g.user.access_modes = u.allowed_modes(lname, g.user.mid)
                return True
                        
        if username_or_token== '':
            if(request.args.get('apikey')!=None):
                validkey = current_app.ms.getapikey(lname)
                if(validkey != None):
                    if(validkey == request.args.get('apikey')):
                        rule = str(request.url_rule)
                        for url in APIURL.apiurls:                                                       
                            if rule == url:
                                return True
                return False
        # print(g.user)


        u = User(lname)
        user = u.verify_auth_token(username_or_token)

        if not user:
        # try to authenticate with username/password
            user = u.get_user_from_db(username = username_or_token)

            if not user or not user.verify_password(password):
                return False

        g.user = user
        gid = g.user.get_group_for_user(g.user.mid)
        if gid:
            g.user.gid = gid
        g.user.access_modes = u.allowed_modes(lname, g.user.mid)
        filters = User.get_password_filters(User, lname)
        if int(filters[2]) > 0 and int(filters[3]) > 0:
            if int(User(lname).check_user_try(lname, g.user.id, filters[3])) > int(filters[3]):
                User(lname).block_user_try(lname, g.user.id, [request.remote_addr, g.user.mid])
        return True
    except NameError:
        return False
        
    else:
        return False


@token_api.route('/lms/api/v1.0/<lname>/token/sso', methods=['GET'])
def get_auth_sso(lname):
    """GET to create a login token. Use this login token as basic authentication username <token>:xyz instead of user:password"""  

  
    try:
  
        if current_app.ms.validname(lname) != True:
            return "ERROR: No such company: " + lname,404

  
        if len(current_app.config['SSO_USER_HEADER']) == 0:
            return jsonify( 'ERROR: SSO NOT CONFIGURED'),404

        header = request.headers.get(current_app.config['SSO_USER_HEADER'])

        if header is None:
            return jsonify({ 'ERROR: no authentication header': current_app.config['SSO_USER_HEADER']}),404 # Was 401


        if current_app.config['SSO_SECRET'] != '':
            if request.headers.get('X-LMS-SECRET') != current_app.config['SSO_SECRET']:
                return jsonify( 'ERROR: invalid secret'),403


        header = header.split('@')[0]

        u = User(lname)
        g.user = u.get_user_from_db(header)

        if g.user is None:
            return jsonify({ 'ERROR: user does not exist': header }),403

        token = g.user.generate_auth_token()
    
        isTeacher = g.user.user_is_teachermid(g.user.mid)
        isJournalAdmin = g.user.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
        gid = g.user.get_group_for_user(g.user.mid)
        expiration = datetime.datetime.now() 
        b = timedelta(seconds=current_app.config['TOKEN_VALID'])
        expiration += b

        libraryactive = False
        if current_app.ms.librarypublicurl(lname) != "":
            
            librarypublicurl = current_app.ms.librarypublicurl(lname)

        return jsonify({ 'token': token.decode('ascii'),'lastname': g.user.lastname, 'firstname': g.user.firstname , 'patronymic': g.user.patronymic, 'expires': expiration  , 'isTeacher': isTeacher, 'isJournalAdmin': isJournalAdmin, 'mid': g.user.mid, 'valid':current_app.config['TOKEN_VALID'] , 'gid': gid, 'librarypublicurl': librarypublicurl, 'libraryactive': libraryactive })

    except NameError:
        return "ERROR: No such company: " + lname,404
        
    else:
        return "Server error",500


@token_api.route('/lms/api/v1.0/<lname>/token2', methods=['GET'])
@auth.login_required
def get_auth_token(lname):
    """GET to create a login token. Use this login token as basic authentication username <token>:xyz instead of user:password"""    
    try:


        if current_app.ms.validname(lname) != True:
            return "ERROR: No such company: " + lname,404


        token = g.user.generate_auth_token()
    
        isTeacher = g.user.user_is_teachermid(g.user.mid)
        isJournalAdmin = g.user.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
        gid = g.user.get_group_for_user(g.user.mid)
        expiration = datetime.datetime.now() 
        b = timedelta(seconds=current_app.config['TOKEN_VALID'])
        expiration += b


        return jsonify({ 'token': token.decode('ascii'),'lastname': g.user.lastname, 'firstname': g.user.firstname , 'patronymic': g.user.patronymic, 'expires': expiration  , 'isTeacher': isTeacher, 'isJournalAdmin': isJournalAdmin, 'mid': g.user.mid, 'valid':current_app.config['TOKEN_VALID'] , 'gid': gid })
    except NameError:
        return "ERROR: No such company: " + lname,404
        
    else:
        return "Server error",500


@token_api.route('/lms/api/v1.0/<lname>/token', methods=['GET'])
def get_auth_token2(lname):
    """GET to create a login token. Use this login token as basic authentication username <token>:xyz instead of user:password"""    
    
    try:
            
        if(request.authorization==None):
            return jsonify( {"error": { "code": 401, "message": "Unauthorized" }})

        if (verify_password(request.authorization.username,request.authorization.password)==False):
            return jsonify( {"error": { "code": 401, "message": "Unauthorized" }})

        check_actual_user = g.user.check_actual_user(g.user.mid)
        if check_actual_user == 0:
            return jsonify({"error": {"code": 401,
                                      "message": "Unauthorized (Данный пользователь не имеет статус 'Текущий' в переменном составе)"}})

        token = g.user.generate_auth_token()
        isTeacher = g.user.user_is_teachermid(g.user.mid)
        isJournalAdmin = g.user.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
        gid = g.user.get_group_for_user(g.user.mid)
        expiration = datetime.datetime.now() 
        b = timedelta(seconds=current_app.config['TOKEN_VALID'])
        expiration += b
        
        if request.environ.get('HTTP_X_FORWARDED_FOR') is None:
            ip = request.environ['REMOTE_ADDR']
        else:
            ip = request.environ['HTTP_X_FORWARDED_FOR']
        
        User(lname).write_log(g.user.id, g.user.mid, ip, current_app.version)

        changePassword = False
        current_app.logger.debug(g.user.need_change_password)
        if g.user.need_change_password is not None and g.user.need_change_password != 0:
            changePassword = True

        libraryactive = False        
        librarypublicurl = None
        if current_app.ms.librarypublicurl(lname) != "":            
            libraryactive = True            
            librarypublicurl = current_app.ms.librarypublicurl(lname)

        return jsonify({ 'need_change_password': changePassword, 'token': token.decode('ascii'),
                         'lastname': g.user.lastname, 'firstname': g.user.firstname, 'patronymic': g.user.patronymic,
                         'expires': expiration, 'isTeacher': isTeacher, 'isJournalAdmin': isJournalAdmin,
                         'mid': g.user.mid, 'valid': current_app.config['TOKEN_VALID'], 'gid': gid,
                         'librarypublicurl': librarypublicurl, 'libraryactive': libraryactive})
    except NameError:
        return jsonify( {"error": { "code": 404, "message": "No such database " + lname }})
        
    else:
        return jsonify( {"error": { "code": 500, "message": "Server exception"  }})



@token_api.route('/lms/api/v1.0/<lname>/token', methods=['POST'])
def get_auth_tokenpost(lname):
    """GET to create a login token. Use this login token as basic authentication username <token>:xyz instead of user:password"""
    try:
        
        data = request.data
        if sys.version_info[0] < 3:
            dataDict = json.loads(data)
        else:
            dataDict = json.loads(data.decode('utf-8'))

        username = None
        password = None
        rfid = None
        if 'username' in dataDict:
            username = dataDict['username']
        if 'password' in dataDict:
            password = dataDict['password']                
        if 'rfid_token' in dataDict:
            rfid = dataDict['rfid_token']
        if (rfid is None):

            if username is None or password is None:
                return jsonify( {"error": { "code": 401, "message": "Неверное имя пользователя или пароль" }})

            if (verify_password(username,password)==False):
                return jsonify( {"error": { "code": 401, "message": "Unauthorized (login and password)" }})

        else:
            if (rfid == ""):
                return jsonify( {"error": { "code": 401, "message": "Unauthorized (rfid)" }})
            if (verify_password(username,password,rfid)==False):
                return jsonify( {"error": { "code": 401, "message": "Unauthorized (rfid) " }})
        check_actual_user = g.user.check_actual_user(g.user.mid)
        if check_actual_user == 0:
            return jsonify( {"error": { "code": 401, "message": "Unauthorized (Данный пользователь не имеет статус 'Текущий' в переменном составе или со статусом 'Уволен' в постоянном составе)" }})
        token = g.user.generate_auth_token()
        isTeacher = g.user.user_is_teachermid(g.user.mid)
        isJournalAdmin = g.user.user_is_rasdel_admin(g.user.mid, "Классный журнал.Администратор")
        gid = g.user.get_group_for_user(g.user.mid)
        if gid:
            g.user.gid = gid
        expiration = datetime.datetime.now() 
        b = timedelta(seconds=current_app.config['TOKEN_VALID'])
        expiration += b
        
        if request.environ.get('HTTP_X_FORWARDED_FOR') is None:
            ip = request.environ['REMOTE_ADDR']
        else:
            ip = request.environ['HTTP_X_FORWARDED_FOR']
        
        User(lname).write_log(g.user.id, g.user.mid, ip, current_app.version)

        changePassword = False        
        if(g.user.need_change_password != None and g.user.need_change_password!=0):
            changePassword = True

        libraryactive = False        
        librarypublicurl = None
        if current_app.ms.librarypublicurl(lname) != "":            
            libraryactive = True            
            librarypublicurl = current_app.ms.librarypublicurl(lname)

        g.user.access_modes = g.user.allowed_modes(lname, g.user.mid)

        return jsonify({'need_change_password': changePassword, 'token': token.decode('ascii'),
                        'lastname': g.user.lastname, 'firstname': g.user.firstname ,
                        'patronymic': g.user.patronymic, 'expires': expiration, 'isTeacher': isTeacher,
                        'isJournalAdmin': isJournalAdmin, 'mid': g.user.mid, 'valid': current_app.config['TOKEN_VALID'],
                        'gid': gid, 'librarypublicurl': librarypublicurl, 'libraryactive': libraryactive,
                        'access_modes': g.user.access_modes})
    except NameError:
        return jsonify( {"error": { "code": 404, "message": "No such database " + lname }})
        
    else:
        return jsonify( {"error": { "code": 500, "message": "Server exception"  }})