import os
import subprocess
from typing import Optional


class FileConverter:

    __output_file_name_pattern = "page_%02d"
    __density = 300
    __output_format = "jpg"

    @staticmethod
    def __get_output_folder(output_file_dir: str, file_path: str) -> str:
        dir_ = output_file_dir or os.path.dirname(file_path)
        base_name = os.path.splitext(os.path.basename(file_path))[0]
        output_folder = os.path.join(dir_, "images_" + base_name)
        os.makedirs(output_folder, exist_ok=True)
        return output_folder

    @classmethod
    def check_package(
        cls
    ) -> bool:
        command = [
            "convert",
            "-version"
        ]
        try:
            subprocess.check_output(command, stderr=subprocess.PIPE)
        except Exception as e:
            return False
        return True

    @classmethod
    def convert(
        cls,
        file_path: str,
        density: Optional[int] = None,
        output_format: Optional[str] = None,
        output_file_dir: Optional[str] = None
    ):
        density = density or cls.__density
        output_format = output_format or cls.__output_format
        output_folder = cls.__get_output_folder(output_file_dir, file_path)

        file_pattern = cls.__output_file_name_pattern + "." + output_format
        pattern = os.path.join(output_folder, file_pattern)
        
        command = [
            "convert",
            "-density",
            str(density),
            file_path,
            pattern
        ]
        subprocess.run(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)