import json
from decimal import Decimal


class RequestUtils:
    @staticmethod
    def get_body(req):
        if req.json:
            return req.json

        data = req.data
        if not data:
            return {}

        return json.loads(data.decode("utf-8"))

    @staticmethod
    def convert_decimal_to_float(data):
        """Рекурсивно преобразует объекты Decimal в float."""
        if isinstance(data, dict):
            for key, value in data.items():
                if isinstance(value, Decimal):
                    data[key] = float(value)
                elif isinstance(value, dict):
                    data.convert_decimal_to_float(value)
        return data

    @staticmethod
    def convert_to_float(data):
        """Рекурсивно преобразует объекты Decimal в float. Написал свой, так как не получилось сделать с методом выше"""
        if isinstance(data, list):
            return [RequestUtils.convert_to_float(item) for item in data]
        elif isinstance(data, dict):
            return {key: RequestUtils.convert_to_float(value) for key, value in data.items()}
        elif isinstance(data, Decimal):
            return float(data)
        return data
