from typing import Any, Dict


class ParamItem:
    def __init__(self, name: str, base: Dict[str, Any]):
        self.name = name
        self.base = base

    def __call__(
        self,
        in_: str = "query",
        required: bool = False,
        example: Any = None,
        **overrides: Any
    ) -> Dict[str, Any]:
        """
        Вернуть словарь с дефолтами и заменами.
        IDE будет подсказывать in_, required, example.
        Остальные параметры (description, enum, type...) можно передать через kwargs.
        ⚡ name всегда фиксированный и не заменяется.
        """
        result = self.base.copy()
        result["name"] = self.name  # имя фиксируем всегда
        result["in"] = in_
        result["required"] = required
        if example is not None:
            result["example"] = example

        # Перезаписываем любые поля, кроме name
        for k, v in overrides.items():
            if k != "name":
                result[k] = v

        return result


class Param:
    lname = ParamItem("lname", {
        "type": "string",
        "description": "Код базы данных (например, studium)",
        "enum": ["studium"],
        "example": "studium"
    })
    from_date = ParamItem("from_date", {
        "type": "string",
        "description": "Начальная дата (YYYY-MM-DD)",
        "example": "2024-01-01"
    })
    to_date = ParamItem("to_date", {
        "type": "string",
        "description": "Конечная дата (YYYY-MM-DD)",
        "example": "2024-12-31"
    })
    idfaculty = ParamItem("idfaculty", {
        "type": "integer",
        "description": "ID факультета (0 = все факультеты)",
        "example": 1
    })
    idcathedra = ParamItem("idcathedra", {
        "type": "integer",
        "description": "Ключ кафедры (0 = все кафедры)",
        "example": 12
    })
    xp_key = ParamItem("xp_key", {
        "type": "integer",
        "description": "Ключ учебного года (school_year.xp_key)",
        "example": 37
    })
    mid = ParamItem("mid", {
        "type": "integer",
        "description": "ID пользователя",
        "example": 2
    })
    division = ParamItem("division", {
        "type": "integer",
        "description": "Фильтр по подразделению (ID)",
        "example": 2
    })
    educationyear = ParamItem("educationyear", {
        "type": "integer",
        "description": "Курс обучения (educationyears.number)",
        "example": 2,
    })
    count = ParamItem("count", {
        "type": "boolean",
        "description": "Если true → возвращает только количество записей",
        "enum": [False, True]
    })
    gid = ParamItem("gid", {
        "type": "integer",
        "description": "Фильтр по ID группы (0 = все группы факультета)",
        "example": 2
    })
    eyid = ParamItem("eyid", {
        "type": "integer",
        "description": "Фильтр по курсу обучения (educationyears.eyid). Если 0 → фильтр отключён.",
        "example": 2
    })
    limit = ParamItem("limit", {
        "type": "integer",
        "description": "Количество записей для возврата",
        "example": 50,
    })
    offset = ParamItem("offset", {
        "type": "integer",
        "description": "Смещение для пагинации",
        "example": 0,
    })
    search = ParamItem("search",{
        "type": "string",
        "description": "Поиск ",
        "example": "Иванов"
    })