update groupname SET idEducationLevel=1 WHERE cid=-1 AND owner_gid=0 AND idEducationLevel IS NULL;

/*
 *   Таблица checkers
 */
DROP TABLE IF EXISTS checkers;
DROP SEQUENCE IF EXISTS checkers_id_seq;
DROP SEQUENCE IF EXISTS checkers_id_seq1;
CREATE SEQUENCE checkers_id_seq;
CREATE TABLE public.checkers (
	id integer NOT NULL DEFAULT NEXTVAL('checkers_id_seq'),
	title varchar NOT NULL,
	sql_check varchar NOT NULL,
	sql_resolve text NULL,
	description text NULL,
	can_resolve int4 DEFAULT 0 NOT NULL,
	q_symbols varchar DEFAULT '###'::character varying NOT NULL,
	no_view_field_prefix varchar DEFAULT '_'::character varying NOT NULL
);
CREATE UNIQUE INDEX checkers_id_idx ON checkers USING btree (id);
INSERT INTO checkers (title,sql_check,sql_resolve,description,can_resolve,q_symbols,no_view_field_prefix) VALUES
	 ('В штате подразделения, нет должности в ЛД','SELECT 
  _mid,
  _xp_pf_id,
  "ФИО"::varchar(200),
  _personal_id,
  struct_type::varchar(200) AS "Структурное подразделение",
  struct_name::varchar(200) AS "Наименование структурного подразделения",
  _pos_id,
  pos_name::varchar(200) AS "Должность"
FROM (
SELECT 
  p.mid AS _mid,
  pf.xp_pf_id AS _xp_pf_id,
  CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS "ФИО",
  dp.sdid AS _personal_id,
  ''Структурное подразделение'' AS struct_type,
  sd.divisionname AS struct_name,
  pos.pid AS _pos_id,
  pos.name AS pos_name
FROM people p
JOIN xp_personal_file pf ON p.mid = pf.mid
JOIN division_personnel dp ON p.mid = dp.mid
JOIN struct_divisions sd ON dp.sdid = sd.sdid
LEFT JOIN positions pos ON dp.positionid = pos.pid
WHERE pf.workstatus = ''Работает'' AND pf."Position" = 0 AND dp.pos_overlay <> TRUE
--
UNION ALL 
--
SELECT 
  p.mid AS _mid,
  pf.xp_pf_id AS _xp_pf_id,
  CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS "ФИО", 
  fp.fpid AS _personal_id,
  ''Факультет'' AS struct_type,
  f.faculty AS struct_name,
  pos.pid AS _pos_id,
  pos.name AS pos_name
FROM people p
JOIN xp_personal_file pf ON p.mid = pf.mid
JOIN faculty_personnel fp ON p.mid = fp.mid
JOIN faculty f ON fp.facultyid = f.idfaculty
LEFT JOIN positions pos ON fp.positionid = pos.pid
WHERE pf.workstatus = ''Работает'' AND pf."Position" = 0 AND fp.pos_overlay <> TRUE 
--
UNION ALL
--
SELECT 
  p.mid AS _mid,
  pf.xp_pf_id AS _xp_pf_id,
  CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS "ФИО", 
  cp.cpid AS _personal_id,
  ''Кафедра'' AS struct_type,
  c.cathedra AS struct_name,
  pos.pid AS _pos_id,
  pos.name AS pos_name
FROM people p
JOIN xp_personal_file pf ON p.mid = pf.mid
JOIN cathedra_personnel cp ON p.mid = cp.mid
JOIN cathedras c ON cp.cid = c.idcathedra
LEFT JOIN positions pos ON cp.positionid = pos.pid
WHERE pf.workstatus = ''Работает'' AND pf."Position" = 0 AND cp.pos_overlay <> TRUE 
) ps','UPDATE xp_personal_file  
SET "Position" = ###_pos_id###
WHERE xp_pf_id = ###_xp_pf_id###','Сотрудники, которые состоят в штате какого-либо подразделения (имеют должность), но информации о должности нет в личном деле.
Если сотрудник попадает в список более одного раза, значит он имеет более одной основной должности, при сиправлении в личном деле сохранится выбранная должность. ',1,'###','_'),
	 ('Сотрудники, у которых в ЛД указана должность по совмещению','SELECT 
  xp_pf_id AS _xp_pf_id,
  fio::varchar(150) AS "ФИО",
  ps_dp.struct_type::varchar(100) AS "Структурное подразделение ЛД",
  ps_dp.struct_name::varchar(100) AS "Наименование подразделения ЛД",
  ps_dp.mid AS _mid,
  ps_dp.pid AS _pid,
  ps_dp.pos_name::varchar(100) AS "Должность ЛД (cовмещение)",
  sp.struct_type::varchar(100) AS "Структурное подразделение (осн.)",
  sp.struct_name::varchar(100) AS "Наименование подразделения (осн.)",
  sp.pos_name::varchar(100) AS "Должность (основная)"
FROM (
  SELECT 
    pf.xp_pf_id,
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    ''Структурное подразделение'' AS struct_type,
    sd.divisionname AS struct_name,
    pos.pid,
    pos."name" AS pos_name
  FROM xp_personal_file pf 
  JOIN people p ON pf.mid = p.mid
  JOIN division_personnel dp ON dp.positionid = pf."Position" AND dp.mid = pf.mid
  JOIN struct_divisions sd ON dp.sdid = sd.sdid
  JOIN positions pos ON pf."Position" = pos.pid
  WHERE dp.pos_overlay = TRUE 
  --
  UNION ALL
  --
  SELECT 
    pf.xp_pf_id,
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    ''Факультет'' AS struct_type,
    f.faculty AS struct_name,
    pos.pid,
    pos."name" AS pos_name
  FROM xp_personal_file pf 
  JOIN people p ON pf.mid = p.mid
  JOIN faculty_personnel fp ON fp.positionid = pf."Position" AND fp.mid = pf.mid
  JOIN faculty f ON fp.facultyid = f.idfaculty
  JOIN positions pos ON pf."Position" = pos.pid
  WHERE fp.pos_overlay = TRUE 
  --
  UNION ALL
  --
  SELECT 
    pf.xp_pf_id,
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    ''Кафедра'' AS struct_type,
    c.cathedra AS struct_name,
    pos.pid,
    pos."name" AS pos_name
  FROM xp_personal_file pf 
  JOIN people p ON pf.mid = p.mid
  JOIN cathedra_personnel cp ON cp.positionid = pf."Position" AND cp.mid = pf.mid
  JOIN cathedras c ON cp.cid = c.idcathedra
  JOIN positions pos ON pf."Position" = pos.pid
  WHERE cp.pos_overlay = TRUE 
) ps_dp
LEFT JOIN (
  SELECT 
    dp2.mid,
    pos_dp."name" AS pos_name,
    ''Структурное подразделение'' AS struct_type,
    sd2.divisionname AS struct_name
  FROM division_personnel dp2  
  JOIN struct_divisions sd2 ON dp2.sdid = sd2.sdid
  JOIN positions pos_dp ON dp2.positionid = pos_dp.pid
  WHERE dp2.pos_overlay <> TRUE
  UNION ALL
  SELECT 
    fp2.mid,
    pos_fp."name" AS pos_name,
    ''Факультет'' AS struct_type,
    f2.faculty AS struct_name
  FROM faculty_personnel fp2
  JOIN faculty f2 ON fp2.facultyid = f2.idfaculty
  JOIN positions pos_fp ON fp2.positionid = pos_fp.pid
  WHERE fp2.pos_overlay <> TRUE
  UNION ALL
  SELECT 
    cp2.mid,
    pos_cp."name" AS pos_name,
    ''Кафедра'' AS struct_type,
    c2.cathedra AS struct_name
  FROM cathedra_personnel cp2
  JOIN cathedras c2 ON cp2.cid = c2.idcathedra
  JOIN positions pos_cp ON cp2.positionid = pos_cp.pid
  WHERE cp2.pos_overlay <> TRUE
) sp ON ps_dp.mid = sp.mid',NULL,'Сотрудники, у которых в личном деле указана должность по совмещению (колонка "Должность (ЛД)") при наличии основной (колонка "Должность (основная)"). Если сотрудник оформлен только на должность по совмещению, а на основную должность не формлен, то в колонке "Должность (основная)" будет пусто.
Автоматически исправить такие ошибки нельзя.

',0,'###','_'),
	 ('Совмещение на основных должностях','SELECT 
  fio::varchar(200) AS ФИО,
  struct_type::varchar(200) AS "Структурное подразделение",
  struct_name::varchar(200) AS "Наименование подразделения",
  pos_name::varchar(200) AS "Должность"
FROM (
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    dp.sdid AS personal_id,
    ''Структурное подразделение'' AS struct_type,
    sd.divisionname AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN (
    SELECT
      struct_personal_mid,
      count_mid
    FROM (
      SELECT struct_personal_mid, COUNT(struct_personal_mid) AS count_mid
      FROM (
        SELECT
          dp.mid AS struct_personal_mid
        FROM division_personnel dp
        WHERE dp.pos_overlay = FALSE
        UNION ALL
        SELECT
          fp.mid AS struct_personal_mid
        FROM faculty_personnel fp
        WHERE fp.pos_overlay = FALSE
        UNION ALL
        SELECT
          cp.mid AS struct_personal_mid
        FROM cathedra_personnel cp
        WHERE cp.pos_overlay = FALSE
        ) ps
      GROUP BY ps.struct_personal_mid
      ) ps2
      WHERE count_mid > 1
    ) ps3 ON p.mid = ps3.struct_personal_mid
  JOIN division_personnel dp ON p.mid = dp.mid
  JOIN struct_divisions sd ON dp.sdid = sd.sdid
  JOIN positions pos ON dp.positionid = pos.pid
  WHERE pf.workstatus = ''Работает'' AND dp.pos_overlay <> TRUE
  --
  UNION ALL
  --
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    fp.fpid AS personal_id,
    ''Факультет'' AS struct_type,
    f.faculty AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN (
    SELECT
      struct_personal_mid,
      count_mid
    FROM (
      SELECT struct_personal_mid, COUNT(struct_personal_mid) AS count_mid
      FROM (
        SELECT
          dp.mid AS struct_personal_mid
        FROM division_personnel dp
        WHERE dp.pos_overlay = FALSE
        UNION ALL
        SELECT
          fp.mid AS struct_personal_mid
        FROM faculty_personnel fp
        WHERE fp.pos_overlay = FALSE
        UNION ALL
        SELECT
          cp.mid AS struct_personal_mid
        FROM cathedra_personnel cp
        WHERE cp.pos_overlay = FALSE
        ) ps
      GROUP BY ps.struct_personal_mid
      ) ps2
      WHERE count_mid > 1
    ) ps3 ON p.mid = ps3.struct_personal_mid
  JOIN faculty_personnel fp ON p.mid = fp.mid
  JOIN faculty f ON fp.facultyid = f.idfaculty
  JOIN positions pos ON fp.positionid = pos.pid
  WHERE pf.workstatus = ''Работает'' AND fp.pos_overlay <> TRUE
  --
  UNION ALL
  --
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    cp.cpid AS personal_id,
    ''Кафедра'' AS struct_type,
    c.cathedra AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN (
    SELECT
      struct_personal_mid,
      count_mid
    FROM (
      SELECT struct_personal_mid, COUNT(struct_personal_mid) AS count_mid
      FROM (
        SELECT
          dp.mid AS struct_personal_mid
        FROM division_personnel dp
        WHERE dp.pos_overlay = FALSE
        UNION ALL
        SELECT
          fp.mid AS struct_personal_mid
        FROM faculty_personnel fp
        WHERE fp.pos_overlay = FALSE
        UNION ALL
        SELECT
          cp.mid AS struct_personal_mid
        FROM cathedra_personnel cp
        WHERE cp.pos_overlay = FALSE
        ) ps
      GROUP BY ps.struct_personal_mid
      ) ps2
      WHERE count_mid > 1
    ) ps3 ON p.mid = ps3.struct_personal_mid
  JOIN cathedra_personnel cp ON p.mid = cp.mid
  JOIN cathedras c ON cp.cid = c.idcathedra
  JOIN positions pos ON cp.positionid = pos.pid
  WHERE pf.workstatus = ''Работает'' AND cp.pos_overlay <> TRUE
  ) ps5 
ORDER BY fio',NULL,'Сотрудники оформленные на несколько основных должностей. Автоматически такую ошибку исправить нельзя.',0,'###','_'),
	 ('Есть записи в шатате подразделения, но статус не "Работает"','SELECT 
  mid AS _mid,
  fio::varchar(200) AS ФИО,
  personal_id AS _personal_id,
  struct_type::varchar(200) AS "Структурное подразделение",
  struct_name::varchar(200) AS "Наименование структурного подразделения",
  pos_name AS "Должность",
  workstatus AS "Текущий статус"
FROM (
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    dp.sdid AS personal_id,
    ''Структурное подразделение'' AS struct_type,
    sd.divisionname AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN division_personnel dp ON p.mid = dp.mid
  JOIN struct_divisions sd ON dp.sdid = sd.sdid
  LEFT JOIN positions pos ON dp.positionid = pos.pid
  WHERE pf.workstatus <> ''Работает'' AND pf."Position" = 0
  --
  UNION ALL
  --
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    fp.fpid AS personal_id,
    ''Факультет'' AS struct_type,
    f.faculty AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN faculty_personnel fp ON p.mid = fp.mid
  JOIN faculty f ON fp.facultyid = f.idfaculty
  LEFT JOIN positions pos ON fp.positionid = pos.pid
  WHERE pf.workstatus <> ''Работает'' AND pf."Position" = 0
  --
  UNION ALL
  --
  SELECT
    p.mid,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    cp.cpid AS personal_id,
    ''Кафедра'' AS struct_type,
    c.cathedra AS struct_name,
    pos.name AS pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN cathedra_personnel cp ON p.mid = cp.mid
  JOIN cathedras c ON cp.cid = c.idcathedra
  LEFT JOIN positions pos ON cp.positionid = pos.pid
  WHERE pf.workstatus <> ''Работает'' AND pf."Position" = 0
) AS ps','UPDATE xp_personal_file  
SET workstatus = ''Работает''
WHERE mid = ###_mid###','Для сотрудника назначенного на должность не установлен статус "Работает".
Автоматическое исправление - сотруднику будет установлен статус "Работает".',1,'###','_'),
	 ('Должности с отсутствующей или нулевой ставкой','SELECT 
  _personal_id,
  _personal_table_name,
  _personal_table_id_name,
  struct_type::varchar(100) AS "Структурное подразделение",
  struct_name::varchar(150) AS "Наименование структурного подразделения",
  _pos_id,
  pos_name::varchar(200) AS "Должность",
  pos_overlay::varchar(30) AS "Вид",
  fio::varchar(200) AS "ФИО"
FROM (
  SELECT 
    dp.dpid AS _personal_id,
    ''division_personnel'' AS _personal_table_name,
    ''dpid'' AS _personal_table_id_name,
    ''Структурное подразделение'' AS struct_type,
    sd.divisionname AS struct_name,
    pos.pid AS _pos_id,
    pos.name AS pos_name,
    CASE 
      WHEN dp.pos_overlay = TRUE THEN ''Основная''
      ELSE ''Совмещение''
    END AS pos_overlay,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio
  FROM division_personnel dp
  JOIN struct_divisions sd ON dp.sdid = sd.sdid
  JOIN positions pos ON dp.positionid = pos.pid
  LEFT JOIN xp_personal_file pf ON dp.positionid = pf."Position" 
  LEFT JOIN people p ON pf.mid = p.mid
  WHERE (dp.rate IS NULL) OR (dp.rate = 0)
  --
  UNION ALL 
  --
  SELECT 
    fp.fpid AS _personal_id,
    ''faculty_personnel'' AS _personal_table_name,
    ''fpid'' AS _personal_table_id_name,
    ''Факультет'' AS struct_type,
    f.faculty AS struct_name,
    pos.pid AS _pos_id,
    pos.name AS pos_name,
    CASE 
      WHEN fp.pos_overlay = TRUE THEN ''Основная''
      ELSE ''Совмещение''
    END AS pos_overlay,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio
  FROM faculty_personnel fp
  JOIN faculty f ON fp.facultyid = f.idfaculty
  JOIN positions pos ON fp.positionid = pos.pid
  LEFT JOIN xp_personal_file pf ON fp.positionid = pf."Position" 
  LEFT JOIN people p ON pf.mid = p.mid
  WHERE (fp.rate IS NULL) OR (fp.rate = 0) 
  --
  UNION ALL
  --
  SELECT 
    cp.cpid AS _personal_id,
    ''cathedra_personnel'' AS _personal_table_name,
    ''cpid'' AS _personal_table_id_name,
    ''Кафедра'' AS struct_type,
    c.cathedra AS struct_name,
    pos.pid AS _pos_id,
    pos.name AS pos_name,
    CASE 
      WHEN cp.pos_overlay = TRUE THEN ''Основная''
      ELSE ''Совмещение''
    END AS pos_overlay,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio
  FROM cathedra_personnel cp
  JOIN cathedras c ON cp.cid = c.idcathedra
  JOIN positions pos ON cp.positionid = pos.pid
  LEFT JOIN xp_personal_file pf ON cp.positionid = pf."Position" 
  LEFT JOIN people p ON pf.mid = p.mid
  WHERE (cp.rate IS NULL) OR (cp.rate = 0) 
) ps
ORDER BY 4, 5, 7','UPDATE ###_personal_table_name### 
SET rate = 100
WHERE ###_personal_table_id_name### = ###_personal_id###','Должности с отсутствующей или нулевой ставкой. По таким должностям будет некорректный расчёт штата.
При автоматическом исправлении ставка будет установлена как "1,00".',1,'###','_'),
	 ('Неправильный статус','SELECT
  p.mid AS _mid,
  CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'')::varchar(250) AS "ФИО",
  pf.workstatus::varchar(100) AS "Статус"
FROM people p
JOIN xp_personal_file pf ON p.mid = pf.mid
WHERE pf.workstatus NOT IN (''Работает'', ''Уволен'', ''Переведен к новому месту службы'', '''', NULL);',NULL,NULL,0,'###','_'),
	 ('Должность в ЛД несоответствует основной должности по штату','SELECT 
  mid AS _mid,
  xp_pf_id AS _xp_pf_id,
  fio::varchar(150) AS ФИО,
  personal_id AS _personal_id,
  struct_type::varchar(150) AS "Структурное подразделение",
  struct_name::varchar(150) AS "Наименование структурного подразделения",
  struct_pos_name::varchar(150) AS "Должность по штату",
  struct_pos_pid AS _struct_pos_pid,
  pf_pos_name::varchar(150) AS "Должность в ЛД"
FROM (
  SELECT
    p.mid,
    pf.xp_pf_id,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    dp.sdid AS personal_id,
    ''Структурное подразделение'' AS struct_type,
    sd.divisionname AS struct_name,
    dp_pos.name AS struct_pos_name,
    dp_pos.pid AS struct_pos_pid,
    pf_pos.name AS pf_pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN division_personnel dp ON p.mid = dp.mid
  JOIN struct_divisions sd ON dp.sdid = sd.sdid
  LEFT JOIN positions dp_pos ON dp.positionid = dp_pos.pid
  LEFT JOIN positions pf_pos ON pf."Position" = pf_pos.pid
  WHERE pf.workstatus = ''Работает'' AND dp.pos_overlay <> TRUE AND pf."Position" <> dp.positionid
  --
  UNION ALL
  --
  SELECT
    p.mid,
    pf.xp_pf_id,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    fp.fpid AS personal_id,
    ''Факультет'' AS struct_type,
    f.faculty AS struct_name,
    fp_pos.name AS struct_pos_name,
    fp_pos.pid AS struct_pos_pid,
    pf_pos.name AS pf_pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN faculty_personnel fp ON p.mid = fp.mid
  JOIN faculty f ON fp.facultyid = f.idfaculty
  LEFT JOIN positions fp_pos ON fp.positionid = fp_pos.pid
  LEFT JOIN positions pf_pos ON pf."Position" = pf_pos.pid
  WHERE pf.workstatus = ''Работает'' AND fp.pos_overlay <> TRUE AND pf."Position" <> fp.positionid
  --
  UNION ALL
  --
  SELECT
    p.mid,
    pf.xp_pf_id,
    CONCAT(p.lastname, '' '', LEFT(p.firstname, 1), ''.'', LEFT(p.patronymic,1), ''.'') AS fio,
    cp.cpid AS personal_id,
    ''Кафедра'' AS struct_type,
    c.cathedra AS struct_name,
    cp_pos.name AS struct_pos_name,
    cp_pos.pid AS struct_pos_pid,
    pf_pos.name AS pf_pos_name,
    pf.workstatus
  FROM people p
  JOIN xp_personal_file pf ON p.mid = pf.mid
  JOIN cathedra_personnel cp ON p.mid = cp.mid
  JOIN cathedras c ON cp.cid = c.idcathedra
  LEFT JOIN positions cp_pos ON cp.positionid = cp_pos.pid
  LEFT JOIN positions pf_pos ON pf."Position" = pf_pos.pid
  WHERE pf.workstatus = ''Работает'' AND cp.pos_overlay <> TRUE AND pf."Position" <> cp.positionid
) AS ps','UPDATE xp_personal_file  
SET "Position" = ###_struct_pos_id###
WHERE xp_pf_id = ###_xp_pf_id###','Должность в личном деле несоответствует основной должности по штату.
Такую ошибку можно исправить автоматически - в личное дуло будет записана основная должность по штату.',1,'###','_');


/*
 *   Таблица announcement_groups
 */
DROP TABLE IF EXISTS announcement_groups;
DROP SEQUENCE IF EXISTS announcement_groups_seq_id;
CREATE SEQUENCE announcement_groups_seq_id;
CREATE TABLE public.announcement_groups (
	agid int4 DEFAULT nextval('announcement_groups_seq_id'::regclass) NULL,
	sorting int4 NULL, -- Порядок сортировки
	group_title varchar NULL, -- Название группы
	query_group varchar NULL, -- Запрос на параметры группы, должен вернуть id, title
	query_people varchar NULL -- запрос на список людей в группе
);
INSERT INTO announcement_groups (sorting,group_title,query_group,query_people) VALUES
	 (3,'Кафедра','SELECT 
  c.idcathedra AS id, 
  3 AS struct_id,
  ''Кафедра'' AS struct_title,
  c.cathedra AS title
FROM cathedras c 
ORDER BY title','SELECT mid
FROM cathedra_personnel cp  
WHERE cp.cid  = %d'),
	 (2,'Факультет','SELECT 
  0 AS sort,
  0 AS id, 
  2 AS struct_id,
  ''Факультет'' AS struct_title,
  ''Все'' AS title
FROM faculty f 
UNION
SELECT 
  1 AS sort,
  f.idfaculty AS id, 
  2 AS struct_id,
  ''Факультет'' AS struct_title,
  faculty AS title
FROM faculty f 
ORDER BY sort, title','SELECT mid
FROM faculty_personnel fp   
WHERE 
  CASE 
    WHEN %0:d > 0 THEN fp.facultyid = %0:d AND mid > 0
    ELSE mid > 0 
  END '),
	 (4,'Роль','SELECT
  0 AS sort,
  0 AS id,
  4 AS struct_id,
  ''Роль'' AS struct_title,
  ''Все'' AS title
FROM permission_groups pg
UNION
SELECT 
  1 AS sort,
  pmid AS id,
  4 AS struct_id,
  ''Роль'' AS struct_title,
  name AS title
FROM permission_groups pg 
ORDER BY sort, title','SELECT mid
FROM permission_groups pg 
JOIN permission2mid pm ON pg.pmid = pm.pmid 
WHERE 
  CASE 
    WHEN %0:d > 0 THEN pg.pmid = %0:d AND mid > 0
    ELSE mid > 0
  END'),
	 (1,'Структурные подразделения','SELECT 
  0 AS sort,
  0 AS id, 
  1 AS struct_id,
  ''Структурные подразделения'' AS struct_title,
  ''Все'' AS title
UNION ALL
SELECT 
  1 AS sort,
  sdid AS id, 
  1 AS struct_id,
  ''Структ. подр.'' AS struct_title,
  divisionname AS title
FROM struct_divisions sd
ORDER BY sort, title','SELECT mid
FROM division_personnel dp 
WHERE 
  CASE 
    WHEN %0:d > 0 THEN dp.sdid = %0:d AND mid > 0
    ELSE mid > 0
  END '),
	 (0,'Все','SELECT 0 AS id, ''Все'' AS title','SELECT mid 
FROM 
(
  SELECT DISTINCT dp.mid
  FROM division_personnel dp 
  UNION ALL
  SELECT fp.mid
  FROM faculty_personnel fp  
  UNION ALL 
  SELECT cp.mid
  FROM cathedra_personnel cp 
) pre
GROUP BY mid');
