/*Удаление содержимого мероприятий, которое не удалялось при удалении самого мероприятия*/
delete from newsclass c where not exists (select 1 from news2 n where c.nid = n.nid);
delete from newsmembers c where not exists (select 1 from news2 n where c.nid = n.nid);
delete from newspositions c where not exists (select 1 from news2 n where c.nid = n.nid);
delete from newsdivisions c where not exists (select 1 from news2 n where c.nid = n.nid);
delete from newsteachers c where not exists (select 1 from news2 n where c.nid = n.nid);

/*
Индивидуальные планы теперь по должностям.
В cpid записывались vw_division.depid
Добавляем поле depid, копируем в него cpid, а в cpid заносим основную должность,
которая ранее и выводилась как должность сотрудника
*/
UPDATE individual_plans ip 
SET depid = cpid
WHERE depid IS NULL;
UPDATE individual_plans ip 
SET cpid = (SELECT vs.id FROM vw_staff vs WHERE vs.mid = ip.mid AND vs.is_main IS TRUE LIMIT 1);

/*Обновляем ведомости, проставляем кафедры как в расписании*/
UPDATE journalcertification jc
SET idcathedra = (
 SELECT s.idcathedra
 FROM vw_schedule vs  
 JOIN nnz_schedule s ON s.sheid = vs.sheid
 WHERE vs.sheid = jc.f_nnz_schedule 
   AND vs.week_id = jc.f_nnz_weeks
   AND COALESCE(s.idcathedra, 0) > 0
  LIMIT 1)
WHERE jc.idcathedra IS NULL; 