from sqlalchemy import create_engine
from sqlalchemy.sql import text
from LMSAPI.api.Models.User import User
from flask import current_app, g
from LMSAPI.api.Models.File import File


class EduDocs:
    def __init__(self, lname):
        self.name = ""
        self.lname = lname

    def getEduDocTypeList(self):
        conn = current_app.ms.db(self.lname).connect()
        query = conn.execute("select * from docs_kinds order by ord;")
        edudoctypeslist = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return edudoctypeslist

    def getEduDocOwnerTypeList(self):
        conn = current_app.ms.db(self.lname).connect()
        query = conn.execute("select * from docs_owner_kinds order by owner_kind;")
        edudoctypeslist = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return edudoctypeslist

    def getEduDocList(self, args):
        conn = current_app.ms.db(self.lname).connect()
        select_table = """SELECT djid, dok.owner_kind as Категория 
        , p.mid, p.LastName || ' ' || p.FirstName ||  ' ' || p.Patronymic as ФИО
        ,registr_nr as "Регистр. номер", docname "Вид документа", date_issued as "Дата выдачи" 
        ,series Серия, nr Номер, "date_GAK" as "Дата принятия решения ГАК", chief_gak "ФИО председателя ГАК", num_protocol "Номер протокола ГАК"
        ,"Comment" Примечание, if (gn.ideducationlevel = 1, 'ВО', 'СПО') ООП, 
        mp.specialization, td.training_direct speciality, po.classificationname"""
        select_count = """SELECT COUNT(*)"""
        sql = """ FROM docs_journal
        LEFT JOIN docs_kinds on docs_journal.doc_kind = docs_kinds.did 
        LEFT JOIN docs_owner_kinds dok on docs_journal.owner_kind = dok.oid 
        LEFT JOIN people p on docs_journal.owner = p.mid 
        LEFT JOIN groupuser gu on p.mid = gu.mid and gu.cid = -1
        LEFT JOIN groupname gn ON gn.gid = gu.gid
        LEFT JOIN militaryprofession mp ON mp.mpid = gn.f_militaryprofession
        LEFT JOIN edu_direction ed ON ed.edu_direct_id = mp.edu_direct_id
        LEFT JOIN training_directions td ON td.training_direct_id = ed.training_direct_id
        LEFT JOIN pek_okso po ON po.code = ed.code
        LEFT JOIN groupuser_transfer AS u 
        LEFT JOIN xp_status AS x ON x.xp_key = u.xp_status ON u.mid = p.mid and u.cid = -1 and u.group_to = gu.gid AND x."Type" IN ('Выпуск')
        WHERE 1 = 1 
        """

        sql_table = select_table + sql
        sql_count = select_count + sql

        if "edudocownertype" in args.keys():
            sql_table += " and dok.oid = :edudocownertype"
            sql_count += " and dok.oid = :edudocownertype"
        if "doctype" in args.keys():
            sql_table += " and docs_kinds.did = :doctype"
            sql_count += " and docs_kinds.did = :doctype"
        if "year" in args.keys():
            sql_table += (
                " AND u.xp_date BETWEEN (SELECT begdate FROM school_year WHERE xp_key = :year) "
                "AND (SELECT enddate FROM school_year WHERE xp_key = :year) "
            )
            sql_count += (
                " AND u.xp_date BETWEEN (SELECT begdate FROM school_year WHERE xp_key = :year) "
                "AND (SELECT enddate FROM school_year WHERE xp_key = :year) "
            )
        if "fio" in args.keys():
            sql_table += " and p.LastName || ' ' || p.FirstName ||  ' ' || p.Patronymic ilike :fio"
            sql_count += " and p.LastName || ' ' || p.FirstName ||  ' ' || p.Patronymic ilike :fio"
        if "number" in args.keys():
            sql_table += " and registr_nr  ilike :number"
            sql_count += " and registr_nr  ilike :number"

        if "datefrom" in args.keys() and "dateto" in args.keys():
            sql_table += " AND docs_journal.date_issued BETWEEN :datefrom AND :dateto "
            sql_count += " AND docs_journal.date_issued BETWEEN :datefrom AND :dateto "
        elif "dateto" in args.keys():
            sql_table += " AND docs_journal.date_issued <= :dateto "
            sql_count += " AND docs_journal.date_issued <= :dateto "
        elif "datefrom" in args.keys():
            sql_table += " AND docs_journal.date_issued >= :datefrom "
            sql_count += " AND docs_journal.date_issued >= :datefrom "

        # Пагинация
        if "paginateFrom" in args.keys() and "maxResults" in args.keys():
            sql_table += " LIMIT :maxResults" + " OFFSET :paginateFrom"
        elif "maxResults" in args.keys():
            sql_table += " LIMIT :maxResults"
        else:
            sql_table += " order by date_issued"

        stmt = text(sql_table)
        stmt_count = text(sql_count)

        for param in [
            "dateto",
            "datefrom",
            "edudocownertype",
            "doctype",
            "year",
            "fio",
            "number",
        ]:
            if param in args:
                stmt = stmt.bindparams(**{param: args[param]})
                stmt_count = stmt_count.bindparams(**{param: args[param]})

        if "paginateFrom" in args.keys() and "maxResults" in args.keys():
            stmt = stmt.bindparams(paginateFrom=args["paginateFrom"])
            stmt = stmt.bindparams(maxResults=args["maxResults"])
        elif "maxResults" in args.keys():
            stmt = stmt.bindparams(maxResults=args["maxResults"])

        query = conn.execute(stmt_count)
        count = query.scalar()

        query = conn.execute(stmt)
        edudoctypeslist = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return {"count": count, "edudoctypeslist": edudoctypeslist}

    def getBaseFileDirecotry(self):
        return current_app.ms.fileroot(self.lname)

    def getEduDocBaseDirectory(self, studentid, id):
        return (
            self.getBaseFileDirecotry()
            + "/People/"
            + str(studentid)
            + "/Documents/"
            + str(id)
        )

    def getEduDocFileList(self, studentid, id):
        return File(self.lname).listFiles(self.getEduDocBaseDirectory(studentid, id))
