# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle


class Educationyear:
    def __init__(self, cname):
        self.lname = cname

    def getListFromRedis(self):
        cachedClist = current_app.ms.redis(self.lname).get("EDUYLIST")
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setListToRedis(self, ylist):
        current_app.ms.redis(self.lname).setex("EDUYLIST", 500, pickle.dumps(ylist))
        return

    def getEducationYearList(self):
        educationYearList = self.getListFromRedis()

        if educationYearList is not None:
            return educationYearList

        conn = current_app.ms.db(self.lname).connect()

        stmt = text("SELECT * FROM educationyears ORDER BY eyid ASC;")

        query = conn.execute(stmt)

        educationYearList = {
            "educationYear": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        self.setListToRedis(educationYearList)

        return educationYearList

    def getEducationYearByYearFacultyCurriculum(
        self, school_year, idfaculty, idcurriculum
    ):
        conn = current_app.ms.db(self.lname).connect()

        sql = """ SELECT distinct ey.eyid, ey.name, ey."number" as kurs 
        FROM 
        (SELECT  cc.id_curriculum_course, tl.tlid 
        FROM curriculum clm 
           JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
            JOIN militaryprofession mp ON mp.mpid=q.mpid 
             JOIN groupname g ON g.f_militaryprofession=mp.mpid 
              JOIN group_history gh ON gh.gid=g.gid  -- ГОД(school_year) из запроса  /lms/api/v1.0/<lname>/year/sy
             JOIN cathedras cs ON cs.idcathedra=g.idcathedra 
              JOIN faculty f ON f.idfaculty=coalesce(g.idfaculty,cs.faculty) 
             JOIN curriculum_detail cd ON cd.idcurriculum=clm.idcurriculum 
              JOIN curriculum_course cc ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
              JOIN study_by_terms sbt ON sbt.id_curr_detail=cd.id_curr_detail and sbt.cathedra is null AND sbt.trim_time>0 
               JOIN educationyears ey ON ey.eyid=sbt.eyid AND ey."number"=gh.year
               JOIN termslist tl ON tl.tlid=sbt.tlid AND tl.eyid=ey.eyid 
        WHERE 1=1 
         """

        if school_year != 0:
            sql = sql + " AND gh.school_year=:school_year "
        if idfaculty != 0:
            sql = sql + " AND (f.idfaculty=:idfaculty OR f.idfaculty=0) "
        if idcurriculum != 0:
            sql = sql + " AND (clm.idcurriculum=:idcurriculum OR clm.idcurriculum=0) "

        sql = (
            sql
            + """GROUP BY cc.id_curriculum_course, tl.tlid  
            ) tab 
             JOIN curriculum_course_details ccd ON ccd.id_curriculum_course=tab.id_curriculum_course AND ccd.tlid=tab.tlid 
             JOIN termslist tl ON tl.tlid=tab.tlid 
             JOIN educationyears ey ON ey.eyid= tl.eyid 
             JOIN curriculum_course cc ON cc.id_curriculum_course=tab.id_curriculum_course 
             JOIN curriculum_detail cd ON cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
             JOIN courses crs ON crs.cid=cd.cid 
             JOIN curriculum clm ON clm.idcurriculum=cd.idcurriculum  
            """
        )

        if school_year == 0 and idfaculty == 0 and idcurriculum == 0:
            sql = "SELECT * FROM educationyears ORDER BY eyid ASC;"

        stmt = text(sql)

        if school_year != 0:
            stmt = stmt.bindparams(school_year=school_year)
        if idfaculty != 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        query = conn.execute(stmt)

        educationYear = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return educationYear

    def get_education_year_by_school_year(
        self, school_year
    ):
        conn = current_app.ms.db(self.lname).connect()
        sql = """ 
            SELECT xp_fill_groupuser_period_all(
                (SELECT begdate FROM school_year WHERE xp_key = :school_year),
                (SELECT enddate FROM school_year WHERE xp_key = :school_year)
            );
            SELECT DISTINCT 
                ey.*
            FROM groupuser_period gp
            JOIN groupname g ON g.gid = gp.gid
            JOIN group_history gh ON gh.gid = g.gid AND gh.school_year = :school_year
            JOIN educationyears ey ON ey.number = gh.year
            ORDER BY eyid ASC
        """
        stmt = text(sql)
        stmt = stmt.bindparams(school_year=school_year)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
