# LMSAPI/API/Faculty.py
from datetime import datetime

from sqlalchemy.sql import text

from LMSAPI.api.Models.Schoolyear import Schoolyear
from flask import current_app, g
import pickle

from LMSAPI.api.Models.User import User


class Message:

    def __init__(self, cname):
        self.idfaculty = 1
        self.faculty = ""
        self.lname = cname

    def serialize(self):
        return {
            'idfaculty': self.idfaculty,
            'faculty': self.faculty
        }

    def get_faculty_list_from_redis(self):
        cachedFlist = current_app.ms.redis(self.lname).get("SYSFLIST")
        if cachedFlist is not None:
            flist = pickle.loads(cachedFlist)
            return flist
        return

    def set_faculty_list_to_redis(self, flist):
        current_app.ms.redis(self.lname).setex("SYSFLIST", 5, pickle.dumps(flist))
        return

    def get_faculty_from_redis(self, id):
        cachedFlist = current_app.ms.redis(self.lname).get("FA" + str(id))
        if cachedFlist is not None:
            flist = pickle.loads(cachedFlist)
            return flist
        return

    def set_faculty_to_redis(self, result):
        current_app.ms.redis(self.lname).setex("FA" + str(result['faculty'][0]['idfaculty']), 5, pickle.dumps(result))
        return

    def getChatList(self, mid):
        conn = current_app.ms.db(self.lname).connect()

        query = """
        SELECT
            mc.ID,
            mc.From,
            mc.To,
            mc.Title,
            IF(mc.To=:mid,mc.From,mc.To) AS Photoid,
            mc.Created AS Created ,
            mc.Updated AS Updated , 
            if(:mid= mc.from, mc.from_last_viewed, mc.to_last_viewed) LastViewed,
            (SELECT COUNT(mm.id) FROM messages_messages mm WHERE mm.chat = mc.id) Count,
            (SELECT COUNT(mm.id) FROM messages_messages mm WHERE mm.chat = mc.id AND mm.id >  IF(:mid= mc.from, mc.from_last_viewed, mc.to_last_viewed)) AS CountNew,
            CAST(concat(TRIM(pf.LastName), ' ', TRIM(pf.FirstName), ' ', TRIM(pf.Patronymic)) AS text) AS FromName,
            CAST(concat(TRIM(pt.LastName), ' ', TRIM(pt.FirstName), ' ', TRIM(pt.Patronymic)) AS text) AS ToName,
            IF(:mid = mc.from, mc.from_hide, mc.to_hide) Hided,
            t.message AS last_message
        FROM messages_chats mc
          JOIN people pf ON pf.mid = mc.from
          JOIN people pt ON pt.mid = mc.to
          JOIN (
                SELECT DISTINCT ON (chat) chat, message
                FROM messages_messages
                ORDER BY chat, created DESC
          ) t ON t.chat = mc.id
        WHERE
          ((mc.from = :mid) OR (mc.to = :mid)) AND
          (:mid = 1 OR IF(mc.from = :mid, mc.from_hide, mc.to_hide) = 0)
          ORDER BY updated DESC;
        --ORDER BY IF(CountNew>0,0,1), updated DESC;
        """
        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)

        query = conn.execute(stmt)

        result = {'chat': [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return result

    def getMessageCount(self, mid, all):

        conn = current_app.ms.db(self.lname).connect()

        query = """
        SELECT
            SUM(CountNew) AS CountNew
        FROM (
            SELECT
                IF(:mid = mc.from , mc.from_last_viewed, mc.to_last_viewed) LastViewed,
                (SELECT COUNT(mm.id) FROM messages_messages mm 
                 WHERE mm.chat = mc.id AND mm.id > IF(:mid= mc.from , mc.from_last_viewed, mc.to_last_viewed)) CountNew
            FROM messages_chats mc
            WHERE
            ((mc.from = :mid) OR (mc.to = :mid)) AND
            (:all = 1 OR IF(mc.from = :mid, mc.from_hide, mc.to_hide) = 0)
            ORDER BY updated DESC
            ) t;
        """
        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(all=all)
        query = conn.execute(stmt)

        newCount = 0
        for row in query:
            if (row.countnew != None):
                newCount = int(row.countnew)

        if newCount is None:
            return 0

        return newCount

    def getChatInfo(self, mid, chatid):

        conn = current_app.ms.db(self.lname).connect()

        query = """
        SELECT
            mc.ID,
            mc.From,
            -- mc.From_Type,
            mc.To,
            --mc.To_Type,
            mc.Title,
            IF(mc.To=:mid,mc.From,mc.To) AS Photoid,
            to_char(mc.Created,'DD.MM.YYYY HH24:MI') AS Created ,
            to_char(mc.Updated,'DD.MM.YYYY HH24:MI') AS Updated , 
            mc.Type,
            IF(:mid = mc.from , mc.from_last_viewed, mc.to_last_viewed) LastViewed,
                (SELECT COUNT(mm.id) FROM messages_messages mm WHERE mm.chat = mc.id) Count,
                (SELECT COUNT(mm.id) FROM messages_messages mm WHERE mm.chat = mc.id AND mm.id > IF(:mid = mc.from , mc.from_last_viewed, mc.to_last_viewed)) CountNew,
            CAST(concat(TRIM(pf.LastName), ' ', TRIM(pf.FirstName), ' ', TRIM(pf.Patronymic))
                AS text) FromName,
            CAST(concat(TRIM(pt.LastName), ' ', TRIM(pt.FirstName), ' ', TRIM(pt.Patronymic)) AS text) ToName,
            (SELECT message
            FROM messages_messages
            WHERE chat = :chatid
            ORDER BY created DESC
            LIMIT 1) AS last_message
        FROM messages_chats mc
            JOIN people pf on pf.mid = mc.from
            JOIN people pt on pt.mid = mc.to
        WHERE
            mc.id = :chatid AND
            ((mc.from = :mid) OR (mc.to = :mid)) 
        """
        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)

        result = {'chatinfo': [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return result

    def getChat(self, mid, chatid):
        conn = current_app.ms.db(self.lname).connect()
        query = """
        SELECT
            mm.ID,
            mm.Parent,
            mm.From,
            mm.Message,
            to_char(mm.Created,'DD.MM.YYYY HH24:MI') AS Created ,
            CAST(concat(TRIM(pf.LastName), ' ', TRIM(pf.FirstName), ' ', TRIM(pf.Patronymic)) AS text) AS FromName,
            IF(mm.id > IF(:mid = mc.from, mc.from_last_viewed, mc.to_last_viewed), 1, 0) AS New
        FROM messages_messages mm
            JOIN messages_chats mc ON mc.id = mm.chat
            JOIN people pf ON pf.mid = mm.from
        WHERE
            mc.id = :chatid AND
            ((mc.from = :mid) OR (mc.to = :mid))
        ORDER BY mm.created, mm.parent;
        """
        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)
        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return result

    def update_messages_chat(self, chatid):
        conn = current_app.ms.db(self.lname).connect()
        User(self.lname).prepare_logger(conn)
        query = """
        UPDATE messages_chats 
        SET
            updated = now()
        WHERE
            id = :chatid;
        """

        stmt = text(query)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)

    def updateMessagesChatFrom(self, mid, chatid, messageid):
        conn = current_app.ms.db(self.lname).connect()
        User(self.lname).prepare_logger(conn)
        query = """
        UPDATE messages_chats 
        SET
            from_last_viewed = :messageid
        WHERE
            id = :chatid AND "from" = :mid ;
        """

        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(chatid=chatid)
        stmt = stmt.bindparams(messageid=messageid)
        query = conn.execute(stmt)

    def updateMessagesChatTo(self, mid, chatid, messageid):
        conn = current_app.ms.db(self.lname).connect()
        User(self.lname).prepare_logger(conn)
        query = """
        UPDATE messages_chats  mc
        SET
            to_last_viewed = :messageid
            WHERE
            id = :chatid and "to" = :mid ;
        """

        stmt = text(query)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(chatid=chatid)
        stmt = stmt.bindparams(messageid=messageid)
        query = conn.execute(stmt)

    def search_users(self, user, composition):
        conn = current_app.ms.db(self.lname).connect()
        where = ""
        sqlargs = {}

        if user:
            where += "AND (:parameter = '' OR (lastname || ' ' || firstname || ' ' || Patronymic) ILIKE '%' || :parameter || '%')"
            sqlargs['parameter'] = user

        if composition == 'constant' and g.user.isTeacher != False:
            query = """
                SELECT p.mid, p.firstname, p.lastname, p.patronymic
                FROM people p
                WHERE EXISTS (
                    SELECT t.mid
                    FROM teachers t
                    INNER JOIN xp_personal_file xp ON t.mid = xp.mid
                    WHERE t.mid = p.mid AND xp.workstatus ILIKE '%Работает%'
                ) {where};
            """.format(where=where)
        elif composition == 'constant' and g.user.isTeacher == False:
            query = """
                SELECT p.mid, p.firstname, p.lastname, p.patronymic
                FROM (
                    -- t: преподаватели расписания
                    SELECT t.*
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    LEFT JOIN nnz_schedule sc ON sc.gid = gn.gid
                    JOIN people t ON t.mid = ANY(sc.teacher_mid)
                    WHERE s.mid = 15401
                
                    UNION
                
                    -- t2: классные руководители
                    SELECT t2.*
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    JOIN people t2 ON t2.mid = gn.class_teacher OR t2.mid = gn.class_teacher2
                    WHERE s.mid = 15401
                    
                    UNION
                
                    -- t3: факультета
                    SELECT t3.*
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    JOIN vw_staff vs ON vs.depid = gn.idfaculty
                    JOIN people t3 ON t3.mid = vs.mid
                    WHERE s.mid = 15401
                    
                    UNION
                
                    -- t4: кафедры
                    SELECT t4.*
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    JOIN vw_staff vs ON vs.depid = gn.idcathedra|536870912
                    JOIN people t4 ON t4.mid = vs.mid
                    WHERE s.mid = 15401
                    
                    UNION
                
                    -- t5: мероприятий
                    SELECT t5.* 
                    FROM newsmembers nm
                    JOIN newsteachers nt ON nm.nid = nt.nid
                    JOIN people t5 ON t5.mid = nt.mid
                    WHERE nm.mid = 15401
                ) AS p
                WHERE 1=1 {where};
            """.format(where=where)
        elif composition == 'temporary':
            query = """
                SELECT p.lastname, p.firstname, p.patronymic, p.mid
                FROM people p
                WHERE EXISTS (
                    SELECT s.mid
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    LEFT JOIN xp_status st ON st.xp_key = ( 
                      SELECT xs.xp_key 
                      FROM groupuser_transfer gt 
                      JOIN xp_status xs ON gt.xp_status = xs.xp_key 
                      WHERE gt.mid = p.mid 
                      ORDER BY gt.xp_date DESC, gt.xp_status 
                      LIMIT 1) 
                    WHERE s.mid = p.mid
                      AND COALESCE(st."Type", '') NOT IN ('Выпуск', 'Отчисление', 'Архивная запись') AND gn.name IS NOT NULL
                ) {where};
            """.format(where=where)
        else:
            query = """
                SELECT p.mid, p.firstname, p.lastname, p.patronymic
                FROM people p
                WHERE EXISTS (
                    SELECT t.mid
                    FROM teachers t
                    INNER JOIN xp_personal_file xp ON t.mid = xp.mid
                    WHERE t.mid = p.mid AND xp.workstatus ILIKE '%Работает%'
                ) {where}
                    
                UNION
                
                SELECT p.mid, p.firstname, p.lastname, p.patronymic
                FROM people p
                WHERE EXISTS (
                    SELECT s.mid
                    FROM students s
                    INNER JOIN groupuser gu ON s.mid = gu.mid
                    LEFT JOIN groupname gn ON gu.gid = gn.gid
                    LEFT JOIN xp_status st ON st.xp_key = ( 
                      SELECT xs.xp_key 
                      FROM groupuser_transfer gt 
                      JOIN xp_status xs ON gt.xp_status = xs.xp_key 
                      WHERE gt.mid = p.mid 
                      ORDER BY gt.xp_date DESC, gt.xp_status 
                      LIMIT 1) 
                    WHERE s.mid = p.mid
                      AND COALESCE(st."Type", '') NOT IN ('Выпуск', 'Отчисление', 'Архивная запись') AND gn.name IS NOT NULL
                ) {where};
            """.format(where=where)
        stmt = text(query)
        query = conn.execute(stmt, sqlargs)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def newChat(self, midfrom, midto, title, message):
        conn = current_app.ms.db(self.lname).connect()
        User(self.lname).prepare_logger(conn)
        query = """
        INSERT INTO messages_chats  ("from", "to",  title,type,created,updated)
        VALUES (:midfrom, :midto, :title,0, now(), now());
        """
        stmt = text(query)
        stmt = stmt.bindparams(midto=midto)
        stmt = stmt.bindparams(midfrom=midfrom)
        stmt = stmt.bindparams(title=title)
        query = conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('messages_chats','id'))"
        stmt = text(sql)
        query = conn.execute(stmt)

        newId = 0
        for row in query:
            newId = row.currval

        if newId is None:
            return -1

        if message != None and message != "":
            messageid = self.newMessage(newId, 0, midfrom, message)
            self.updateMessagesChatFrom(midfrom, newId, messageid)

        return newId

    def deleteChat(self, midfrom, chatid):

        conn = current_app.ms.db(self.lname).connect()

        # Check permission
        query = """select id from messages_chats where "from" = :midfrom and id=:chatid"""
        stmt = text(query)
        stmt = stmt.bindparams(midfrom=midfrom)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)

        chat = 0

        for row in query:
            chat = int(row.id)

        # We do not have right to do this
        if chat == 0:
            return False

        query = """
delete from messages_messages where chat =:chatid
        """
        stmt = text(query)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)

        query = """
delete from messages_chats where "from" = :midfrom and id=:chatid
        """
        stmt = text(query)
        stmt = stmt.bindparams(midfrom=midfrom)
        stmt = stmt.bindparams(chatid=chatid)
        query = conn.execute(stmt)

        return True

    def newMessage(self, chatid, parentid, midfrom, message):
        conn = current_app.ms.db(self.lname).connect()
        query = """
            INSERT INTO messages_messages (chat, parent, "from", message, created)
            VALUES (:chatid, :parentid, :midfrom, :message, now());
        """
        stmt = text(query)
        stmt = stmt.bindparams(chatid=chatid)
        stmt = stmt.bindparams(parentid=parentid)
        stmt = stmt.bindparams(midfrom=midfrom)
        stmt = stmt.bindparams(message=message)
        query = conn.execute(stmt)
        sql = "SELECT currval(pg_get_serial_sequence('messages_messages','id'))"
        stmt = text(sql)
        query = conn.execute(stmt)

        newId = 0
        for row in query:
            newId = row.currval

        if newId is None:
            return -1

        self.update_messages_chat(chatid)

        return newId

    def deleteMessage(self, messageid, midfrom):

        conn = current_app.ms.db(self.lname).connect()

        # Check permission
        query = """select id,parent from messages_messages where "from" = :midfrom and id=:messageid"""
        stmt = text(query)
        stmt = stmt.bindparams(midfrom=midfrom)
        stmt = stmt.bindparams(messageid=messageid)
        query = conn.execute(stmt)

        msg = 0
        parent = 0
        for row in query:
            msg = int(row.id)
            parent = int(row.parent)

        # We do not have right to do this
        if msg == 0:
            return False

        query = """
        delete from messages_messages where id =:messageid
        """
        stmt = text(query)
        stmt = stmt.bindparams(messageid=messageid)
        query = conn.execute(stmt)

        query = """
        update messages_messages set parent=:newparent where parent =:messageid
        """
        stmt = text(query)
        stmt = stmt.bindparams(newparent=parent)
        stmt = stmt.bindparams(messageid=messageid)
        query = conn.execute(stmt)

        return True
