# coding=UTF-8
# LMSAPI/API/Term.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Ooop:

    def __init__(self,cname):
        self.lname = cname
   
    def getFromRedis(self,id):
        cachedClist = current_app.ms.redis(self.lname).get("OOOP"+str(id))
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setToRedis(self,ooopobj,id):
        current_app.ms.redis(self.lname).setex("OOOP" + str(id),180,pickle.dumps(ooopobj))
        return




    def calculateAverage(self,detaillist):

        gradesum = 0

        for d in detaillist:
            gradesum = gradesum + (int(d['value']) / 10000) * float(d['avg_grade'])

        return round(gradesum,2)

    def competenceLevel(self,averageGrade):

        averageGrade = float(averageGrade)
        
        if(averageGrade>=4.5):
            return "высокий (отлич.)"
        if(averageGrade>=3.75):
            return "средний (хорошо)"
        if(averageGrade>=2.7):
            return "низкий (удовл.)"
        if(averageGrade>0):
            return "критический (неудовл.)"
        
        return ""

    def roundOoopDetails(self,oopdetails):


        for z in oopdetails:
            z['avg_grade'] = round(float(z['avg_grade']),2)

        return oopdetails



    def getOoopDetails(self,mid,syid,demandid,competecode):

        conn = current_app.ms.db(self.lname).connect()
      
        q1 = """SELECT val.id, cast(val.value as text), c.cid,c.title, c.course_index, c.cid,
cast(COALESCE((SELECT avg(grade::integer)
FROM nnz_sh_grades g
LEFT OUTER JOIN nnz_schedule s ON g.sheid = s.sheid
WHERE student_mid = :mid and s.cid = c.cid and grade in ('5', '4', '3', '2', '1')) ,0) as text) avg_grade
FROM  (SELECT v.id, v.value, v.cid     
       FROM   comp_course_cur v   
       WHERE v.syid=:syid and v.q_demand_id=:q_demand_id AND compet_code_id=:competecode ) val      
       JOIN courses c ON c.cid=val.cid """

        stmt = text(q1)
        stmt = stmt.bindparams(q_demand_id=demandid)    
        stmt = stmt.bindparams(syid=syid)    
        stmt = stmt.bindparams(mid=mid)    
        stmt = stmt.bindparams(competecode=competecode)    
        query = conn.execute(stmt)

        ooopdetail =  [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]
        return ooopdetail

    def getOoop(self,id):

        
        cached = self.getFromRedis(id)
        
        if cached is not None:
            return cached

        conn = current_app.ms.db(self.lname).connect()
        

        q1 = """SELECT g.syid , g.f_militaryprofession
            FROM groupname g
            INNER JOIN groupuser gu ON gu.gid = g.gid
            WHERE gu.mid = :mid"""
        stmt = text(q1)
        stmt = stmt.bindparams(mid=id)    
        query = conn.execute(stmt)

        syid = 0
        f_militaryprofession = 0

        for row in query:
            f_militaryprofession = row.f_militaryprofession
            syid = row.syid

        if(syid==0):
            return None
        if(f_militaryprofession==0):
            return None



        q2 = """SELECT c.q_demand_id /*73*/
 FROM studyyears2curriculum AS l 
 JOIN  curriculum            AS c ON c.idcurriculum = l.idcurriculum
 JOIN  qualif_demands        AS q ON q.q_demand_id = c.q_demand_id
 WHERE l.syid = :syid  AND q.mpid = :f_militaryprofession
"""
        stmt = text(q2)
        stmt = stmt.bindparams(f_militaryprofession=f_militaryprofession)    
        stmt = stmt.bindparams(syid=syid)    
        query = conn.execute(stmt)

        q_demand_id = 0

        for row in query:
            q_demand_id = row.q_demand_id

        if(q_demand_id==0):
            return None



        q3 = """SELECT   codes.cc_id, cc.compet_code, cc.study_result   
FROM qualif_demands q    
JOIN curriculum c ON c.q_demand_id=q.q_demand_id     
JOIN studyyears2curriculum s2c On s2c.idcurriculum=c.idcurriculum     
JOIN militaryprofession mp ON mp.mpid=q.mpid      
JOIN edu_direction ed ON ed.edu_direct_id=mp.edu_direct_id       
JOIN  preparation_structure ps ON ps.ps_id =ed.program_level       
JOIN training_directions td ON td.training_direct_id = ed.training_direct_id      
JOIN (SELECT d3.edu_direct_id, d3c.cc_id FROM direct_demand_3a d3         
      JOIN competence_codes_direct_demand_3a d3c ON d3c.dd3_id= d3.direct_demand3a_id       
      UNION SELECT dd3.edu_direct_id,dd3.COmpet_code_id as cc_id FROm direct_demand_3 dd3) codes ON codes.edu_direct_id = ed.edu_direct_id          
JOIN competence_codes cc ON cc.compet_code_id = codes.cc_id 
WHERE 1=1  AND s2c.syid=:syid AND q.q_demand_id=:q_demand_id
GROUP BY codes.cc_id, cc.compet_code, cc.study_result 
ORDER BY cc.compet_code 

"""
        stmt = text(q3)
        stmt = stmt.bindparams(q_demand_id=q_demand_id)    
        stmt = stmt.bindparams(syid=syid)    
        query = conn.execute(stmt)

        ooop =  [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        ooopp = []

        for z in ooop:
            
            
            z['detail'] = self.getOoopDetails(id,syid,q_demand_id,z['cc_id'])
            z['averageGrade'] = self.calculateAverage(z['detail'])
            z['competenceLevel'] = self.competenceLevel(z['averageGrade'])
            z['detail']  = self.roundOoopDetails(z['detail'])
            ooopp.append(z)

        self.setToRedis(ooopp,id)

        return ooopp
