# coding=UTF-8
from sqlalchemy import create_engine, null
from sqlalchemy.sql import text
from flask import current_app


class RPD:
    def __init__(self, cname):
        self.lname = cname

    def getRPDSubjet(self, cid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        DROP TABLE IF EXISTS tmp_org_start;
        CREATE TEMPORARY TABLE tmp_org_start AS
        SELECT 
            DISTINCT o.cid, 
            COALESCE(o.oid, -1) oid,
            COALESCE(o.prev_ref, -1) prev_ref,
            COALESCE(o.level, 0) AS "level", 
            o.title, o.description, 
            case o.module when 0 then -1 else o.module end,
            o.termlist_id,  
            o.position, 
            o.title_index, 
            COALESCE(archive, 0) AS archive 
        FROM organizations o
        WHERE 1 = 1 AND o.cid = :cid
        AND COALESCE(o.module,0) IN (0,-1);
        
        SELECT o.* FROM tmp_org_start o  LEFT JOIN termslist tl on tl.tlid = o.termlist_id LEFT JOIN educationyears ey ON ey.eyid=tl.eyid 
        WHERE 1=1 AND COALESCE(archive, 0) = 0
        ORDER BY  ey."number"::integer, ey.eyid,tl."number"::integer, tl.tlid, o.level, o.position, o.prev_ref, o.title,o.oid
        """

        stmt = text(sql)
        stmt = stmt.bindparams(cid=cid)
        query = conn.execute(stmt)

        result = {"RDP": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]}

        return result

    def add_rpd_subject(self, body):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            INSERT INTO organizations(title, cid, level, prev_ref, module, position, __s_year_id,
                                        __teacher_mid, title_index, termlist_id, description)
            VALUES('{title}', {cid}, {level}, {prev_ref}, {module}, {position}, {__s_year_id},
                    {__teacher_mid}, '{title_index}', {termlist_id}, {description})
            RETURNING *
        """.format(
            title=body.get("title"),
            cid=body.get("cid"),
            level=body.get("level"),
            prev_ref=body.get("prev_ref"),
            module=body.get("module"),
            position=body.get("position"),
            __s_year_id=body.get("__s_year_id") or "null",
            __teacher_mid=body.get("__teacher_mid") or "null",
            title_index=body.get("title_index"),
            termlist_id=body.get("termlist_id"),
            description=body.get("description") or "null",
        )

        stmt = text(sql)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor][0]

    def delete_rpd_subjects(self, oid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            DELETE FROM organizations
            WHERE oid = {oid}
            RETURNING oid
        """.format(
            oid=oid
        )

        stmt = text(sql)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor][0]

    def update_items_block(self, data_list, query_param=None):
        conn = current_app.ms.db(self.lname).connect()
        new_id = data_list[0].get("oid")
        if not query_param:
            for i, item in enumerate(data_list):
                if i != 0:
                    if item.get("delete"):
                        # item[i+1]["prev_ref"] = item[i-1].get("oid")
                        sql = """
                            DELETE FROM organizations
                            WHERE oid = {oid};
                        """.format(
                            oid=item.get("oid")
                        )
                        conn.execute(text(sql))
                        del data_list[i]
                    if item.get("oid"):
                        new_id = new_id
                        sql = """
                            UPDATE organizations SET title='{title}', cid={cid}, level={level}, prev_ref={prev_ref}, module={module},
                            position={position}, __s_year_id={__s_year_id}, __teacher_mid={__teacher_mid},
                            title_index='{title_index}', termlist_id={termlist_id}, description='{description}'
                            WHERE oid = {oid};
                        """.format(
                            title=item.get("title"),
                            cid=item.get("cid"),
                            level=item.get("level"),
                            prev_ref=data_list[i - 1].get("oid"),
                            module=item.get("module"),
                            position=i - 1,
                            __s_year_id=item.get("__s_year_id") or "null",
                            __teacher_mid=item.get("__teacher_mid") or "null",
                            title_index=item.get("title_index") or "null",
                            termlist_id=item.get("termlist_id") or "null",
                            description=item.get("description") or "null",
                            oid=item.get("oid"),
                        )
                        conn.execute(text(sql))
                    else:
                        # id = None
                        if data_list[i - 1].get("oid"):
                            id = data_list[i - 1].get("oid")
                        else:
                            id = new_id
                        sql = """
                            INSERT INTO organizations(cid, level, module, termlist_id, title, prev_ref, position)
                            VALUES({cid}, {level}, {module}, {termlist_id}, '{title}', {prev_ref}, {position}) RETURNING oid;
                        """.format(
                            title=item.get("title"),
                            cid=item.get("cid"),
                            level=item.get("level"),
                            prev_ref=id,
                            module=item.get("module"),
                            termlist_id=item.get("termlist_id") or "null",
                            position=i - 1,
                        )
                        query = conn.execute(text(sql))
                        new_id = [
                            dict(zip(tuple(query.keys()), i)) for i in query.cursor
                        ][0].get("oid")
        else:
            for i, item in enumerate(data_list):
                # print("NEW_ID", new_id)
                # item["prev_ref"] = data_list[i - 1].get("oid")
                # print("UPDATING",data_list[i].get("title"), data_list[i].get("oid"), data_list[i - 1].get("oid"))
                if item.get("oid"):
                    new_id = new_id
                    sql = """
                        UPDATE organizations SET title='{title}', cid={cid}, level={level}, prev_ref={prev_ref}, module={module},
                        position={position}, __s_year_id={__s_year_id}, __teacher_mid={__teacher_mid},
                        title_index='{title_index}', termlist_id={termlist_id}, description='{description}'
                        WHERE oid = {oid};
                    """.format(
                        title=item.get("title"),
                        cid=item.get("cid"),
                        level=item.get("level"),
                        prev_ref=-1,
                        module=item.get("module"),
                        position=i,
                        __s_year_id=item.get("__s_year_id") or "null",
                        __teacher_mid=item.get("__teacher_mid") or "null",
                        title_index=item.get("title_index") or "null",
                        termlist_id=item.get("termlist_id") or "null",
                        description=item.get("description") or "null",
                        oid=item.get("oid"),
                    )
                    # print(text(sql))
                    conn.execute(text(sql))
                else:
                    sql = """
                        INSERT INTO organizations(cid, level, module, termlist_id, title, prev_ref, position)
                        VALUES({cid}, {level}, {module}, {termlist_id}, '{title}', {prev_ref}, {position}) RETURNING oid;
                    """.format(
                        title=item.get("title"),
                        cid=item.get("cid"),
                        level=item.get("level"),
                        prev_ref=-1,
                        module=item.get("module"),
                        termlist_id=item.get("termlist_id") or "null",
                        position=i,
                    )
                    query = conn.execute(text(sql))
                    new_id = [dict(zip(tuple(query.keys()), i)) for i in query.cursor][
                        0
                    ].get("oid")
                    conn.execute(text(sql))
        return True

    def updateRPDSubjects(self, data_list, idcurriculum, cid):
        conn = current_app.ms.db(self.lname).connect()
        trans = conn.begin()

        try:
            sql_delete = """
                DELETE FROM organizations 
                WHERE oid IN (
                    SELECT o.oid 
                    FROM organizations o
                    LEFT JOIN termslist tl ON tl.tlid = o.termlist_id
                    JOIN curriculum_detail cd ON cd.idcurriculum = :idcurriculum AND cd.cid = o.cid
                    WHERE (o.cid = :cid OR 0 = :cid)
                );
            """
            conn.execute(text(sql_delete), {"idcurriculum": idcurriculum, "cid": cid})

            sql_upsert = """
                INSERT INTO organizations(
                    oid, title, cid, level, prev_ref, module, position, 
                    __s_year_id, __teacher_mid, title_index, termlist_id, description
                )
                VALUES(
                    :oid, :title, :cid, :level, :prev_ref, :module, :position,
                    :__s_year_id, :__teacher_mid, :title_index, :termlist_id, :description
                )
                ON CONFLICT (oid) DO UPDATE SET
                    title = EXCLUDED.title,
                    cid = EXCLUDED.cid,
                    level = EXCLUDED.level,
                    prev_ref = EXCLUDED.prev_ref,
                    module = EXCLUDED.module,
                    position = EXCLUDED.position,
                    __s_year_id = EXCLUDED.__s_year_id,
                    __teacher_mid = EXCLUDED.__teacher_mid,
                    title_index = EXCLUDED.title_index,
                    termlist_id = EXCLUDED.termlist_id,
                    description = EXCLUDED.description
                RETURNING *
            """

            for item in data_list:
                if not item.get("oid"):
                    continue

                conn.execute(
                    text(sql_upsert),
                    {
                        "oid": item.get("oid"),
                        "title": item.get("title"),
                        "cid": cid,
                        "level": item.get("level"),
                        "prev_ref": item.get("prev_ref"),
                        "module": item.get("module") or -1,
                        "position": item.get("position"),
                        "__s_year_id": item.get("__s_year_id"),
                        "__teacher_mid": item.get("__teacher_mid"),
                        "title_index": item.get("title_index"),
                        "termlist_id": item.get("termlist_id"),
                        "description": item.get("description"),
                    },
                )
            trans.commit()
            return True
        except Exception as e:
            print(e)
            trans.rollback()
            raise e
