# LMSAPI/API/Term.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Rate:
   
    def getRate(self, lname, id):
        conn = current_app.ms.db(lname).connect()
        
        sql = """select  
        g.gid,
        g.year,
        f.idfaculty
        from groupuser gu 
        inner join groupname g on (gu.gid = g.gid)
        left outer join cathedras cat on g.idcathedra = cat.idcathedra
        left outer join faculty f on  f.idfaculty = coalesce(g.idfaculty, cat.faculty)
        where gu.mid = :id and g.cid = -1"""

        stmt = text(sql)
        stmt = stmt.bindparams(id=id)  
        query = conn.execute(stmt)

        gid = None
        year = None
        idfaculty = None

        for row in query:
            gid = row.gid
            year = row.year
            idfaculty = row.idfaculty
        
        if gid is None:
            return None
        if idfaculty is None:
            return None
        if year is None:
            return None

        sql = """DROP TABLE IF EXISTS tmp_grades;
CREATE TEMPORARY TABLE tmp_grades 
as
(
select gu.mid, 
g.gid,
g.year,
f.idfaculty  , regexp_split_to_table((regexp_replace(coalesce(sg.grade, '0'), '[^0-9]+', '', 'g')), '') grade
from groupuser gu 
inner join groupname g on (gu.gid = g.gid)
left outer join cathedras cat on g.idcathedra = cat.idcathedra
left outer join faculty f on  f.idfaculty = coalesce(g.idfaculty, cat.faculty)
left outer join nnz_sh_grades sg on (gu.mid = sg.student_mid)
left outer join nnz_weeks w on gu.mid = sg.student_mid and w.week_id = sg.week_id
left outer join term_weeks tw on (w.week_id = tw.week_id) and  tw.trmid = (select trmid
from terms
where now() > str_to_date(term_begin, '%d.%m.%Y') 
order by str_to_date(term_end, '%d.%m.%Y') desc
limit 1)
where f.idfaculty = :idfaculty);"""

        stmt = text(sql)
        stmt = stmt.bindparams(idfaculty=idfaculty)  
        query = conn.execute(stmt)

        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where gid = :gid
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(gid=gid)  
        query = conn.execute(stmt)

        ratesList = []
        
        if query is not None:
            ratesList.append( {'gid': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})
    
        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where year = :year
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(year=year)  
        query = conn.execute(stmt)

        if query is not None:
            ratesList.append( {'year': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})

        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where idfaculty = :idfaculty
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(idfaculty=idfaculty)  
        query = conn.execute(stmt)
        

        if query is not None:
            ratesList.append( {'idfaculty': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})

        return ratesList

    def getRateExam(self, lname, id, syear, term):
        conn = current_app.ms.db(lname).connect()
        
        sql = """select  
        g.gid,
        g.year,
        f.idfaculty
        from groupuser gu 
        inner join groupname g on (gu.gid = g.gid)
        left outer join cathedras cat on g.idcathedra = cat.idcathedra
        left outer join faculty f on  f.idfaculty = coalesce(g.idfaculty, cat.faculty)
        where gu.mid = :id and g.cid = -1"""

        stmt = text(sql)
        stmt = stmt.bindparams(id=id)  
        query = conn.execute(stmt)

        gid = None
        year = None
        idfaculty = None

        for row in query:
            gid = row.gid
            year = row.year
            idfaculty = row.idfaculty
        
        if gid is None:
            return None
        if idfaculty is None:
            return None
        if year is None:
            return None

        sql = """DROP TABLE IF EXISTS tmp_grades;
CREATE TEMPORARY TABLE tmp_grades 
as
(
select sg.mid, 
max(g.gid) gid,
max(g.year) "year",
max(f.idfaculty) idfaculty , regexp_split_to_table((regexp_replace(coalesce(max(sg.grade), '0'), '[^0-9]+', '', 'g')), '') grade
from groupuser gu 
inner join groupname g on (gu.gid = g.gid)
left outer join cathedras cat on g.idcathedra = cat.idcathedra
left outer join faculty f on  f.idfaculty = coalesce(g.idfaculty, cat.faculty)
left outer join term_grades sg on (gu.mid = sg.mid) and sg.grade in ('2', '3', '4', '5')
left outer join terms t on  t.trmid = sg.trmid
left outer join school_year sy  on  t.year = sy.xp_key
where sy.xp_key = :year and f.idfaculty = :idfaculty and (t.trmid = :term or 0 = :term)
group by sg.mid, sg.cid, sg.trmid);"""

        stmt = text(sql)
        stmt = stmt.bindparams(idfaculty=idfaculty)  
        stmt = stmt.bindparams(year=syear)  
        stmt = stmt.bindparams(term=term)  
        query = conn.execute(stmt)

        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where gid = :gid
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(gid=gid)  
        query = conn.execute(stmt)

        ratesList = []
        
        if query is not None:
            ratesList.append( {'gid': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})
    
        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where year = :year
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(year=year)  
        query = conn.execute(stmt)

        if query is not None:
            ratesList.append( {'year': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})

        sql = """SELECT row_number() OVER () num, *
FROM (
SELECT  mid, xp_f_get_mid_fio(mid, 1), cast(round(avg(cast(grade as int)),2) as varchar(4)) as avg
from tmp_grades
where idfaculty = :idfaculty
and grade > ''
group by mid
order by 3 desc, 2) EEE"""

        stmt = text(sql)
        stmt = stmt.bindparams(idfaculty=idfaculty)  
        query = conn.execute(stmt)
        

        if query is not None:
            ratesList.append( {'idfaculty': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]})

        return ratesList
