# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle
from LMSAPI.api.Models.File import File

class Test:

    def __init__(self,cname):
        self.lname = cname
   
    def getTestType(self):

        conn = current_app.ms.db(self.lname).connect()
        
        sql = """select et.typeid as typeid, et.typename as testtype
from eventtools et 
where trmtid IN (7,8) or processtypeid = 3
order by typename"""


        stmt = text(sql)
        query = conn.execute(stmt)
        curriculum = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return curriculum


    def getTestResult(self,semester,courseid,groupid,testtype):

        conn = current_app.ms.db(self.lname).connect()
        
        sql = """SELECT nnz_fill_journalcert (:semester, '01-01-2000', :courseid, :groupid, :testtype);
 
 SELECT student, lessondate, lessonshorttype, grade,jcid
 FROM journal  
 WHERE lessonid <> 99 and jcid IS NOT null
 ORDER BY  
 (case when mid = 99999 then 3 when mid = 999999 then 2 when mid = 9999999 then 1 else 0 END),         
 LessonUnixDate, sheid, Student, LessonID;"""


        stmt = text(sql)

        stmt = stmt.bindparams(semester=semester)    
        stmt = stmt.bindparams(courseid=courseid)    
        stmt = stmt.bindparams(groupid=groupid)    
        stmt = stmt.bindparams(testtype=str(testtype))    


        query = conn.execute(stmt)
        curriculum = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return curriculum


    def getBaseFileDirecotry(self):
        return current_app.ms.fileroot(self.lname)

    def getTestBaseDirectory(self,testid):
        return self.getBaseFileDirecotry() + "/journalcertification/"+str(testid)
   
    def listTestFiles(self,testid):
        return File(self.lname).listFiles(self.getTestBaseDirectory(testid))


    def getTestJcid(self,testresult):

        maxfile = 0

        for tfid in testresult:
            if tfid['jcid'] > maxfile:
                maxfile = tfid['jcid']

        return maxfile

    def getTestFiles(self,testresult):

        #current_app.logger.debug(testresult)

        maxfile = 0

        for tfid in testresult:
            if tfid['jcid'] > maxfile:
                maxfile = tfid['jcid']

        return self.listTestFiles(maxfile)