from flask import jsonify, request, g
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Course import Course
from flask_cors import CORS

from LMSAPI.api.utils.swagger_comments import SwaggerComments
from LMSAPI.api.utils.swagger_utils import swagger_doc

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

course_api = Blueprint("course_api", __name__)

CORS(course_api)


# Get all course for a faculty
@course_api.route(
    "/lms/api/v1.0/<lname>/course/<int:groupid>/<int:termid>", methods=["GET"]
)
@auth.login_required
def getCourses(lname, groupid, termid):
    """GET with ID of Cathedra to get list of groups"""
    result = Course().getCourseListGT(lname, groupid, termid)
    if result is None:
        return jsonify(success=False), 404

    return jsonify([fa.serialize() for fa in result])


@course_api.route(
    "/lms/api/v1.0/<lname>/lessonplans/course",
    methods=["GET"],
)
@auth.login_required
def get_lesson_plans_courses(lname):
    """GET with ID of Cathedra to get list of groups"""
    idcurriculum = request.args.get("idcurriculum", default=0, type=int)
    idmetacourse = request.args.get("idmetacourse", default=0, type=int)

    result = Course().get_lesson_plans_сourse_list(lname, idcurriculum, idmetacourse)
    if result is None:
        return jsonify(success=False), 404

    return jsonify([fa.serialize() for fa in result])


@course_api.route(
    "/lms/api/v1.0/<lname>/course/teacher/<int:groupid>/<int:termid>", methods=["GET"]
)
@auth.login_required
def getCoursesForTeacher(lname, groupid, termid):
    """GET with ID of Cathedra to get list of groups"""
    result = Course().get_course_list_gt_for_teacher(lname, groupid, termid, g.user.mid)
    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


# Get all course for a faculty
@course_api.route("/lms/api/v1.0/<lname>/course/<int:id>", methods=["GET"])
@auth.login_required
def getCourse(id, lname):
    """GET with ID to get details for a Group"""
    result = Course().getCourse(lname, id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


# Get all course
@course_api.route("/lms/api/v1.0/<lname>/course", methods=["GET"])
@auth.login_required
def getAllCourses(lname):
    result = Course().getCourseList(lname)

    if not result:
        return jsonify(success=False), 404

    return jsonify(result)


# Get all course
@course_api.route("/lms/api/v1.0/<lname>/students_projects/course", methods=["GET"])
@auth.login_required
@swagger_doc(SwaggerComments.course_api_get_courses_by_students_projects)
def get_courses_by_students_projects(lname):
    xp_key = request.args.get("xp_key", default=None, type=int)
    trmid = request.args.get("trmid", default=None, type=int)
    eyid = request.args.get("eyid", default=None, type=int)
    result = Course().get_course_by_school_year_eyid_trmid(lname, xp_key, trmid, eyid)
    if not result:
        return jsonify(success=False), 404

    return jsonify(result)


# Get all courses for curriculum
@course_api.route(
    "/lms/api/v1.0/<lname>/course/filters", methods=["GET"]
)
@auth.login_required
@swagger_doc(SwaggerComments.course_api_get_courses_by_curriculum_metacourse_cathedra)
def get_courses_by_curriculum_metacourse_cathedra(lname):
    idcurriculum = request.args.get("idcurriculum", default=0, type=int)
    idmetacourse = request.args.get("idmetacourse", default=0, type=int)
    idcathedra = request.args.get("idcathedra", default=0, type=int)
    xp_key = request.args.get("xp_key", default=0, type=int)
    syid = request.args.get("syid", default=0, type=int)
    result = Course().get_courses_by_curriculum_metacourse_cathedra(lname, xp_key, idcurriculum, idmetacourse, idcathedra, syid)

    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)


@course_api.route(
    "/lms/api/v1.0/<lname>/course/<int:syid>/<int:idcurriculum>/<int:idmetacourse>",
    methods=["GET"],
)
@auth.login_required
def getCourseByYearCorriculumMetaCourse(idcurriculum, syid, idmetacourse, lname):
    if idcurriculum == 0 and syid == 0 and idmetacourse == 0:
        result = Course().getAllCourse(lname)
    else:
        result = Course().getCourseByYearCorriculumMetaCourse(
            lname,
            syid,
            idcurriculum,
            idmetacourse,
        )
    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@course_api.route(
    "/lms/api/v1.0/<lname>/course/<int:syid>/<int:idcurriculum>/<int:idmetacourse>/<int:idcathedra>",
    methods=["GET"],
)
@auth.login_required
def getCourseByYearCorriculumMetaCourseCathedra(
    idcurriculum, syid, idmetacourse, idcathedra, lname
):
    if idcurriculum == 0 and syid == 0 and idmetacourse == 0 and idcathedra == 0:
        result = Course().getAllCourse(lname)
    else:
        result = Course().getCourseByYearCorriculumMetaCourseCathedra(
            lname,
            syid,
            idcurriculum,
            idmetacourse,
            idcathedra,
        )
    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


# Get courses for student
@course_api.route("/lms/api/v1.0/<lname>/course/student/<int:trmid>", methods=["GET"])
@auth.login_required
def getAllCoursesForStudent(lname, trmid):
    result = Course().getCourseListForStudent(lname, trmid)
    if not result:
        return jsonify(success=False), 404

    return jsonify(result)


@course_api.route(
    "/lms/api/v1.0/<lname>/course/complex_thematic_planning/<int:curriculumid>",
    methods=["GET"],
)
@auth.login_required
def get_course_by_curriculum_complex_thematic_planning(lname, curriculumid):
    if curriculumid == 0:
        result = Course().get_courses_by_curriculum_metacourse_cathedra(lname, 0, 0, 0, 0, 0)
    else:
        result = Course().get_course_by_curriculum_complex_thematic_planning(
            lname, curriculumid
        )

    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)
