from flask import Blueprint, jsonify, request
from flask_cors import CORS
from LMSAPI.api.Models.CronTasks import CronTasks, CronTaskType
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.request_utils import RequestUtils

cron_api = Blueprint('cron_api', __name__)

CORS(cron_api)

@cron_api.route("/lms/api/v1.0/<string:lname>/cron", methods=["POST"])
@auth.login_required
def create_cron(lname: str):
    data_dict = RequestUtils.get_body(request)

    task_type = data_dict.get("task_type")

    if not task_type:
        return jsonify({"message": "task_type is required"}), 400

    if not CronTaskType.is_valid(task_type):
        return jsonify({"message": "task_type is invalid"}), 400
    
    task_type = CronTaskType(task_type)
    
    task_params = data_dict.get("task_params")
    try:
        task_params = CronTasks.validate_task_params(task_type, task_params)
    except Exception as e:
        return jsonify({"message": str(e)}), 400
    
    if not CronTasks.check_cron_table(lname):
        return jsonify({"message": "cron table not exists"}), 500

    CronTasks.create_cron_task(lname, task_type, task_params)
    return jsonify({"message": "success"}), 201