from typing import Union, Tuple, Any

from flask import jsonify, request, json
from flask import Blueprint
from isort.settings import default

from LMSAPI.api.Models.DisciplinesCourses import DisciplinesCourses
from flask_cors import CORS

from LMSAPI.api.Views.TokenAPI import auth

discipline_courses_api = Blueprint("discipline_courses_api", __name__)

CORS(discipline_courses_api)

# FOR meta_courses (default)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/create_course', methods=['POST'])
@auth.login_required
def create_course(lname: str) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = DisciplinesCourses().create_course(lname, data)
    if not res:
        return jsonify(success=False), 404
    res = {**res, **data}
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/create_many_courses', methods=['POST'])
@auth.login_required
def create_disciplines_many_blocks(lname: str) -> Union[Tuple[Any, int], list]:
    data_list = json.loads(request.data)
    res = DisciplinesCourses().create_many_courses(lname, data_list)
    if not res:
        return jsonify(success=False), 404
    for i, item in enumerate(res):
        res[i] = ({**item, **data_list[i]})
    return jsonify(res)

@discipline_courses_api.route('/lms/api/v1.0/<lname>/disciplines_course/<int:course_id>', methods=['GET'])
# @auth.login_required
def get_discipline_course(lname: str, course_id: int) -> Union[Tuple[Any, int], dict]:
    res = DisciplinesCourses().get_discipline_course(lname, course_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/get_disciplines_many_courses', methods=['GET'])
# @auth.login_required
def get_disciplines_many_courses(lname: str) -> Union[Tuple[Any, int], list]:
    limit = request.args.get("limit") or None
    offset = request.args.get("offset") or None
    res = DisciplinesCourses().get_disciplines_many_courses(lname, limit, offset)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/update_discipline_course/<int:course_id>', methods=['PUT'])
@auth.login_required
def update_discipline_course(lname: str, course_id: int) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = DisciplinesCourses().update_discipline_course_meta(lname, course_id, data)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


# for rpd courses (course)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/create_rpd_course', methods=['POST'])
@auth.login_required
def create_rpd_course(lname: str) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = DisciplinesCourses().create_rpd_course(lname, data)
    if not res:
        return jsonify(success=False), 404
    res = {**res, **data}
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/create_many_rpd_courses', methods=['POST'])
@auth.login_required
def create_many_rpd_courses(lname: str) -> Union[Tuple[Any, int], list]:
    data_list = json.loads(request.data)
    res = DisciplinesCourses().create_many_rpd_courses(lname, data_list)
    if not res:
        return jsonify(success=False), 404
    for i, item in enumerate(res):
        res[i] = ({**item, **data_list[i]})
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/disciplines_rpd_course/<int:course_id>', methods=['GET'])
@auth.login_required
def get_discipline_rpd_course(lname: str, course_id: int) -> Union[Tuple[Any, int], dict]:
    res = DisciplinesCourses().get_discipline_rpd_course(lname, course_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/get_disciplines_many_rpd_courses', methods=['GET'])
@auth.login_required
def get_disciplines_many_rpd_courses(lname: str) -> Union[Tuple[Any, int], list]:
    limit = request.args.get("limit") or None
    offset = request.args.get("offset") or None
    res = DisciplinesCourses().get_disciplines_many_rpd_courses(lname, limit, offset)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/update_discipline_rpd_course/<int:course_id>', methods=['PUT'])
@auth.login_required
def update_discipline_rpd_course(lname: str, course_id: int) -> Union[Tuple[Any, int], dict]:
    data = json.loads(request.data)
    res = DisciplinesCourses().update_discipline_rpd_course(lname, course_id, data)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@discipline_courses_api.route('/lms/api/v1.0/<lname>/teacher_reviews/meta_course', methods=['GET'])
@auth.login_required
def get_disciplines_by_teacher_reviews(lname: str) -> Union[Tuple[Any, int], list]:
    idcathedra = request.args.get("idcathedra", type=int, default=None)
    if idcathedra:
        res = DisciplinesCourses().get_disciplines_by_cathedra(lname, idcathedra)
    else:
        courses = DisciplinesCourses().get_disciplines_many_courses(lname, None, None)
        res = []
        for course in courses:
            res.append({"id": course["id"],"name": course["name"]})
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)
