from typing import Union, Tuple, Any

from flask import jsonify, request
from flask import Blueprint
from flask_cors import CORS

from LMSAPI.api.Models.EducationDirections import EducationDirections, MilitaryProfession
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.swagger_comments import SwaggerComments
from LMSAPI.api.utils.swagger_utils import swagger_doc

education_directions_api = Blueprint('education_directions_api', __name__)

CORS(education_directions_api)


# FOR edu_direction TABLE

@education_directions_api.route('/lms/api/v1.0/<lname>/education_directions', methods=['POST'])
@auth.login_required
def create_education_dir(lname: str) -> Union[Tuple[Any, int], dict]:
    res = EducationDirections().create_edu_dir(lname, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/many_education_directions', methods=['POST'])
@auth.login_required
def create_many_education_dirs(lname: str) -> Union[Tuple[Any, int], list]:
    res = EducationDirections().create_many_edu_dirs(lname, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)

@education_directions_api.route('/lms/api/v1.0/<lname>/education_directions/<int:edu_dir_id>', methods=['GET'])
@auth.login_required
def get_education_dir(lname: str, edu_dir_id: int) -> Union[Tuple[Any, int], dict]:
    res = EducationDirections().get_education_dir(lname, edu_dir_id)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/education_directions', methods=['GET'])
@auth.login_required
def get_many_education_dirs(lname: str) -> Union[Tuple[Any, int], list]:
    res = EducationDirections().get_many_education_dirs(lname)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/education_directions/<int:edu_dir_id>', methods=['PUT'])
@auth.login_required
def update_education_dir(lname: str, edu_dir_id: int) -> Union[Tuple[Any, int], list]:
    res = EducationDirections().update_education_dir(lname, edu_dir_id, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


# FOR militaryprofession TABLE


@education_directions_api.route('/lms/api/v1.0/<lname>/military_prof', methods=['POST'])
@auth.login_required
def create_mp(lname: str) -> Union[Tuple[Any, int], list]:
    res = MilitaryProfession().create_mp(lname, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/many_military_prof', methods=['POST'])
@auth.login_required
def create_many_mp(lname: str) -> Union[Tuple[Any, int], list]:
    res = MilitaryProfession().create_many_mp(lname, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/military_prof/<int:mpid>', methods=['GET'])
@auth.login_required
def get_mp(lname: str, mpid: int) -> Union[Tuple[Any, int], dict]:
    res = MilitaryProfession().get_mp(lname, mpid)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/military_prof', methods=['GET'])
@auth.login_required
@swagger_doc(SwaggerComments.education_directions_api_get_many_mps)
def get_many_mps(lname: str) -> Union[Tuple[Any, int], list]:
    res = MilitaryProfession().get_many_mps(lname)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)


@education_directions_api.route('/lms/api/v1.0/<lname>/military_prof/<int:mpid>', methods=['PUT'])
@auth.login_required
def update_mp(lname: str, mpid: int) -> Union[Tuple[Any, int], list]:
    res = MilitaryProfession().update_mp(lname, mpid, request.json)
    if not res:
        return jsonify(success=False), 404
    return jsonify(res)
