# coding=UTF-8
import sys
from decimal import Decimal

from flask import jsonify, request, json
from flask import Blueprint

from LMSAPI.api.Models.EnrollAnswers import EnrollAnswers
from LMSAPI.api.Models.EnrollQuestions import EnrollQuestions
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS

enroll_answers_api = Blueprint("enroll_answers_api", __name__)

CORS(enroll_answers_api)


@enroll_answers_api.route(
    "/lms/api/v1.0/<lname>/enroll_answers",
    methods=["GET"],
)
@auth.login_required
def get_enroll_answers_all(lname):
    question = request.args.get("question", default=None, type=int)
    answer_group = request.args.get("answer_group", default=None, type=int)
    correct = request.args.get("correct", default=None)

    # Корректная обработка значения параметра private
    if correct is not None:
        correct = correct.lower() in ["true", "1", "t", "y", "yes"]

    result = EnrollAnswers().get_enroll_answers_all(
        lname, question, answer_group, correct
    )

    if result is None:
        return jsonify(success=False), 404

    # Convert Decimal to float
    for row in result:
        for key, value in row.items():
            if isinstance(value, Decimal):
                row[key] = float(value)

    return jsonify(result)


@enroll_answers_api.route(
    "/lms/api/v1.0/<lname>/enroll_answers/<int:id>",
    methods=["GET"],
)
@auth.login_required
def get_enroll_answers_by_id(lname, id: int):
    result = EnrollAnswers().get_enroll_answers_by_id(lname, id)

    if result is None:
        return jsonify(success=False), 404

    for key, value in result.items():
        if isinstance(value, Decimal):
            result[key] = float(value)

    return jsonify(result)


@enroll_answers_api.route(
    "/lms/api/v1.0/<lname>/enroll_answers",
    methods=["POST"],
)
@auth.login_required
def create_enroll_answers(lname):
    data = request.data
    if not data:
        return jsonify({"error": "No data provided"}), 400

    if sys.version_info[0] < 3:
        data = json.loads(data)
    else:
        data = json.loads(data.decode("utf-8"))

    result = EnrollAnswers().create_enroll_answers(lname, data)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(success=True), 201


@enroll_answers_api.route(
    "/lms/api/v1.0/<lname>/enroll_answers/<int:id>",
    methods=["PUT"],
)
@auth.login_required
def update_enroll_answers(lname, id: int):
    data = request.data
    if not data:
        return jsonify({"error": "No data provided"}), 400

    if sys.version_info[0] < 3:
        data = json.loads(data)
    else:
        data = json.loads(data.decode("utf-8"))

    result = EnrollAnswers().update_enroll_answers(lname, id, data)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(success=True), 201


@enroll_answers_api.route(
    "/lms/api/v1.0/<lname>/enroll_answers/<int:id>",
    methods=["DELETE"],
)
@auth.login_required
def delete_enroll_answers(lname, id: int):
    result = EnrollAnswers().delete_enroll_answers(lname, id)

    if result is None:
        return jsonify(success=False), 404
    return jsonify(success=True), 200
