from flask import Flask, jsonify, request, current_app, send_from_directory
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint

from LMSAPI.api.Models.LessonPlans import LessonPlans
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

lesson_plans_api = Blueprint("lesson_plans_api", __name__)

CORS(lesson_plans_api)


@lesson_plans_api.route(
    "/lms/api/v1.0/<lname>/lessonplans/subjects/<int:school_year>/<int:idfaculty>/<int:idcurriculum>/<int:cid>/<int:meta_course>/<int:eyid>/<int:tlid>",
    methods=["GET"],
)
@auth.login_required
@user_permission_modes("Режимы", "План проведения занятий", ["Нет"])
def getLessonPlansSubjects(
    lname, school_year, idfaculty, idcurriculum, cid, meta_course, eyid, tlid
):
    paginateFrom = request.args.get("paginateFrom")
    maxResults = request.args.get("maxResults")

    lesson_plans = LessonPlans(lname)
    result = lesson_plans.getLessonPlansSubjet(
        school_year,
        idfaculty,
        idcurriculum,
        cid,
        meta_course,
        eyid,
        tlid,
        paginateFrom,
        maxResults,
    )
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)
