import os

from flask import jsonify, current_app, send_from_directory, request, g
from flask import Blueprint
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Methodical import Methodical
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

methodical_api = Blueprint('methodical_api', __name__)

CORS(methodical_api)


@methodical_api.route('/lms/api/v1.0/<lname>/methodical/faculty', methods=['GET'])
@auth.login_required
def getMethodicalFaculty(lname):
    m = Methodical(lname)
    res = m.getMethodicalFacultyList()

    return jsonify(res)


@methodical_api.route(
    "/lms/api/v1.0/<lname>/methodical/<int:facultyid>", methods=["GET"]
)
@auth.login_required
def getMethodical(lname, facultyid):
    m = Methodical(lname)
    res = m.getMethodical(facultyid, g.user.mid)

    return jsonify(res)


@methodical_api.route(
    "/lms/api/v1.0/<lname>/methodical/<int:facultyid>/<int:mrid>",
    methods=["GET"],
)
@auth.login_required
def getMethodicalList(lname, facultyid, mrid):
    m = Methodical(lname)
    res = m.getMethodicalList(facultyid, g.user.mid, mrid)
    try:
        for file_info in res:
            if file_info["mr_isfile"] == 2:
                path = m.getMethodFileLocation(file_info["mrid"])
                with open(path + "/" + file_info["mr_name"], "r") as f:
                    file_info["url"] = f.readlines()[1].strip("\n")
    except:
        error = "Error: {} can't be open".format(file_info["mr_name"])
        print(error)

    return jsonify(res)


@methodical_api.route(
    "/lms/api/v1.0/<lname>/methodical/<int:mrid>/<filename>",
    methods=["GET"],
)
@auth.login_required
def getMethodicalFile(lname, mrid, filename):
    file_path = Methodical(lname).getMethodFileLocation(mrid)
    ip_address = (
        request.headers.get("X-Forwarded-For")
        or request.headers.get("X-Real-IP")
        or request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=file_path,
        file_name=filename,
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=g.user.id,
        user_mid=g.user.mid,
        ip_address=ip_address,
    )
