import os
from flask import jsonify, current_app, send_from_directory, request, g, send_file
from flask import Blueprint
from flask_cors import CORS

from LMSAPI.api.Models.MethodicalPlan import MethodicalPlan
from LMSAPI.api.Models.Report import Report
from LMSAPI.api.Views.TokenAPI import auth

report_api = Blueprint('report_api', __name__)

CORS(report_api)


@report_api.route("/lms/api/v1.0/<lname>/report", methods=["GET"])
@auth.login_required
def get_report(lname):
    """
        Первая страница со списком отчетов,
        формируется на основе прав.
    """
    years = Report(lname).list_report(g.user.mid)
    return jsonify(years)