from flask import Flask,jsonify, request, current_app
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.ScientificWork import ScientificWork
from flask_cors import CORS

scientific_work_api = Blueprint('scientific_work_api', __name__)

CORS(scientific_work_api)

@scientific_work_api.route('/lms/api/v1.0/<lname>/scientific_work/', methods=['GET'])
@auth.login_required
def getScientificWork(lname):
    
    result = ScientificWork().getScientificWork(lname, request.args)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)