from flask import Flask,jsonify, request, current_app
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Search import Search
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

search_api = Blueprint('search_api', __name__)

CORS(search_api)

@search_api.route('/lms/api/v1.0/<lname>/search/<name>', methods=['GET'])
@auth.login_required
def searchAll(lname,name):
    
    s = Search(lname)

    result = s.searchAll(name)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)


@search_api.route('/lms/api/v1.0/<lname>/search/u/<name>', methods=['GET'])
@auth.login_required
def searchUser(lname,name):
    
    s = Search(lname)

    result = s.searchUser(name)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)

@search_api.route('/lms/api/v1.0/<lname>/search/c/<name>', methods=['GET'])
@auth.login_required
def searchCourse(lname,name):
    
    s = Search(lname)

    result = s.searchCourse(name)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)