from flask import Flask,jsonify, request, current_app,send_from_directory, g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Test import Test
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

test_api = Blueprint('test_api', __name__)

CORS(test_api)


@test_api.route('/lms/api/v1.0/<lname>/testtype', methods=['GET'])
@auth.login_required
def getTestType(lname):
    """GET with ID of Cathedra to get list of groups"""
    result = Test(lname).getTestType()

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)


@test_api.route('/lms/api/v1.0/<lname>/testresult/<int:semester>/<int:courseid>/<int:groupid>/<int:testtype>', methods=['GET'])
@auth.login_required
def getTestResult(lname,semester,courseid,groupid,testtype):
    """GET with ID of Cathedra to get list of groups"""
    result = Test(lname).getTestResult(semester,courseid,groupid,testtype)

    if result is None:
        return jsonify(success=False),404

    res = {}

    res['participants'] = result
    res['files'] = Test(lname).getTestFiles(result)
    res['jcid'] = Test(lname).getTestJcid(result)
    return jsonify(res)


@test_api.route('/lms/api/v1.0/<lname>/testresult/<int:jcid>/<filename>', methods=['GET'])
@auth.login_required
def getTestFile(lname,jcid,filename):
    
    path = Test(lname).getTestBaseDirectory(jcid)
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=path,
        file_name=filename,
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=g.user.id,
        user_mid=g.user.mid,
        ip_address=ip_address
    )