import os
from flask import current_app
from LMSAPI import scheduler
from LMSAPI.api.Models.CronTasks import CronTaskType, CronTasks
from LMSAPI.api.utils.file_converter import FileConverter


def file_image_converter():
    with scheduler.app.app_context():
        lservers = [
            {
                "name": lserver.get("NAME"),
                "file_path": lserver.get("FILEROOT")
            }
            for lserver in current_app.config.get("LMSSERVERS")
        ]

    if not FileConverter.check_package():
        with scheduler.app.app_context():
            current_app.logger.error("imagemagick is not installed")
        return


    for lserver in lservers:
        name = lserver.get("name")
        if not CronTasks.check_cron_table(name):
            with scheduler.app.app_context():
                current_app.logger.error("cron table not exists")
            continue
        file_root = lserver.get("file_path")
        tasks = CronTasks.get_cron_tasks(name, CronTaskType.image_converter)

        for task in tasks:
            try:
                params = task.get("task_params")
                if not params:
                    raise Exception("task_params is required")
                file_path = params.get("file_path")
                if not file_path:
                    raise Exception("file_path is required")
                file_path = os.path.join(file_root, file_path)
                if not os.path.exists(file_path):
                    raise Exception("file not exists")
                density = params.get("density")
                output_format = params.get("output_format")
                output_file_dir = os.path.join(file_root, params.get("output_file_dir", "") or "")
                FileConverter.convert(file_path, density, output_format, output_file_dir)
            except Exception as e:
                CronTasks.update_task(name, task.get("id"), status="failed", error_msg=str(e))
            else:
                CronTasks.update_task(name, task.get("id"), status="completed")


