# Wrapper for GPG

import subprocess
import os, stat
from pathlib import Path
import tempfile
GPGHOME="/opt/nintegra/gpg"

if not (os.path.isdir(GPGHOME)):
    try:
        Path(GPGHOME).mkdir(parents=True, exist_ok=True)
        os.chmod(GPGHOME,stat.S_IRWXU )
    except Exception as ex:
        print("ERROR:",str(ex))
        exit(1)

def createKey(keyname, password):   
    if len(keyname)<5:
        print("Min 5 characters for key name")
        return False
    gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,'--passphrase-fd','0', '--pinentry-mode','loopback','--quick-generate-key' ,keyname.encode('utf-8'), 'rsa4096' ,'cert encrypt sign' ,'5y'],stdin=subprocess.PIPE)
    gpgprocess.stdin.write(password.encode("utf-8"))
    gpgprocess.stdin.close()
    gpgprocess.wait()
    return True

def getGPGVersion():
    try:
        gpgprocess = subprocess.Popen(["gpg",'--version','--homedir='+GPGHOME], stdout=subprocess.PIPE,)    
        version_info = ""
        for line in iter(gpgprocess.stdout.readline, b''):
            version_info = version_info+line.decode('utf-8')
        return { "status": "OK", "version": version_info}
    except Exception as ex:
        return { "status": "ERROR", "error": str(ex)}

def extractPublicKey(keyname, password):
    gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,'--armor','--export',keyname.encode('utf-8')], stdout=subprocess.PIPE,)    
    public_key = ""
    for line in iter(gpgprocess.stdout.readline, b''):
        public_key = public_key+line.decode('utf-8')
    return public_key

def extractPrivateKey(keyname, password):
    gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,'--passphrase-fd','0', '--pinentry-mode','loopback','--export-secret-key','--armor' ,'--export-options','backup',keyname.encode('utf-8')],stdin=subprocess.PIPE, stdout=subprocess.PIPE)
    gpgprocess.stdin.write(password.encode("utf-8"))
    gpgprocess.stdin.close()
    gpgprocess.wait()
    private_key = ""
    for line in iter(gpgprocess.stdout.readline, b''):
        private_key = private_key+line.decode('utf-8')    
    return private_key

def importPublicKey(keydata):
    gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,'--import'],stdin=subprocess.PIPE)
    gpgprocess.stdin.write(keydata.encode("utf-8"))
    gpgprocess.stdin.close()
    gpgprocess.wait()
    return True
    
def importPrivateKey(keydata,password):
    with tempfile.NamedTemporaryFile(mode='w', delete=False) as keyfile:
        keyfile.write(keydata)
        keyfile.close()
        gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,'--passphrase-fd','0', '--pinentry-mode','loopback','--import', keyfile.name],stdin=subprocess.PIPE)
        gpgprocess.stdin.write(password.encode("utf-8"))
        gpgprocess.stdin.close()
        gpgprocess.wait()
        os.unlink(keyfile.name)
        return True
    return False

def encodeFile(file, recipients, password):
    if not os.path.isfile(file):
        print("Not a file "+ file)
        return False
    args = ["gpg",'--homedir='+GPGHOME]
    args.append("--encrypt")
    args.append("--yes")
    args.append("--output")
    args.append(file+".gpg")
    for recp in recipients:
        args.append("-r")
        args.append(recp)

    if password is not None:
        args.append("--sign")
        gpgprocess = subprocess.Popen(args,stdin=subprocess.PIPE)
        gpgprocess.stdin.write(password.encode("utf-8"))
        gpgprocess.stdin.close()
        gpgprocess.wait()
    else:
        gpgprocess = subprocess.Popen(args)
        gpgprocess.wait()
    return True

def decodeFile(file, password):
    if not os.path.isfile(file):        
        return {"result": "Not a file "+file, "status": "error"}
    
    args = ["gpg",'--homedir='+GPGHOME,'--passphrase-fd','0', '--pinentry-mode','loopback']        
    args.append("--yes")
    args.append("-d")
    args.append("--output")
    outputfile =file[:-4] 
    args.append(outputfile)
    args.append(file)
    gpgprocess = subprocess.Popen(args,stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    gpgprocess.stdin.write(password.encode("utf-8"))
    gpgprocess.stdin.close()
    gpgprocess.wait()
    result = ""
    for line in iter(gpgprocess.stdout.readline, b''):
        line = line.decode('utf-8')  
        result = result + line
    
    if gpgprocess.stderr is not None:
        for line in iter(gpgprocess.stderr.readline, b''):
            line = line.decode('utf-8')  
            result = result + line

    res = {"result": result, "status": "error"}
    if(gpgprocess.returncode==0):
        res['status']="ok"

    return res


def getKeyData(keyname=None, secret=False):
    if secret:
        lk ='--list-secret-key'
    else:
        lk = '--list-key'
    if keyname is None:
        gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,lk], stdout=subprocess.PIPE,)     
    else:
        gpgprocess = subprocess.Popen(["gpg",'--homedir='+GPGHOME ,lk,keyname.encode('utf-8')], stdout=subprocess.PIPE,)     
    
    keyData = {}   
    for line in iter(gpgprocess.stdout.readline, b''):
        line = line.decode('utf-8')         
        if(line.find("pub")==0):
            data = line.strip().split()            
            keyData['crypt'] = data[1]
            keyData['issued'] = data[2]
            keyData['feature'] = data[3]
            exp = line.split(":")[1].split(']')[0].strip()
            keyData['expires'] = exp
            keyData['type'] = 'public'
        elif (line.find("uid")==0):
            data = line.split()
            #keyData['trust'] = data[1]
            keyData['owner'] = data[-1]
        elif(line.find("sec")==0):
            data = line.split()            
            keyData['crypt'] = data[1]
            keyData['issued'] = data[2]
            keyData['feature'] = data[3]

            exp = line.split(":")[1].split(']')[0].strip()

            keyData['expires'] = exp
            keyData['type'] = 'private'
        else:
            if(len(line)>5):
                keyData['keyid'] = line.strip()   
    return keyData